package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.{
  NonZeroAndMaxString,
  RuleSetLimit,
  MatchmakingRuleSetName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeMatchmakingRuleSetsRequest(
    names: Optional[Iterable[MatchmakingRuleSetName]] = Optional.Absent,
    limit: Optional[RuleSetLimit] = Optional.Absent,
    nextToken: Optional[NonZeroAndMaxString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsRequest = {
    import DescribeMatchmakingRuleSetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsRequest
      .builder()
      .optionallyWith(
        names.map(value =>
          value.map { item =>
            MatchmakingRuleSetName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.names)
      .optionallyWith(limit.map(value => RuleSetLimit.unwrap(value): Integer))(
        _.limit
      )
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribeMatchmakingRuleSetsRequest.ReadOnly =
    zio.aws.gamelift.model.DescribeMatchmakingRuleSetsRequest
      .wrap(buildAwsValue())
}
object DescribeMatchmakingRuleSetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribeMatchmakingRuleSetsRequest =
      zio.aws.gamelift.model.DescribeMatchmakingRuleSetsRequest(
        names.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def names: Optional[List[MatchmakingRuleSetName]]
    def limit: Optional[RuleSetLimit]
    def nextToken: Optional[NonZeroAndMaxString]
    def getNames: ZIO[Any, AwsError, List[MatchmakingRuleSetName]] =
      AwsError.unwrapOptionField("names", names)
    def getLimit: ZIO[Any, AwsError, RuleSetLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsRequest
  ) extends zio.aws.gamelift.model.DescribeMatchmakingRuleSetsRequest.ReadOnly {
    override val names: Optional[List[MatchmakingRuleSetName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.names())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.primitives.MatchmakingRuleSetName(item)
          }.toList
        )
    override val limit: Optional[RuleSetLimit] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.gamelift.model.primitives.RuleSetLimit(value))
    override val nextToken: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsRequest
  ): zio.aws.gamelift.model.DescribeMatchmakingRuleSetsRequest.ReadOnly =
    new Wrapper(impl)
}
