package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.{
  PositiveInteger,
  PlayerSessionId,
  NonZeroAndMaxString,
  ArnStringModel
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribePlayerSessionsRequest(
    gameSessionId: Optional[ArnStringModel] = Optional.Absent,
    playerId: Optional[NonZeroAndMaxString] = Optional.Absent,
    playerSessionId: Optional[PlayerSessionId] = Optional.Absent,
    playerSessionStatusFilter: Optional[NonZeroAndMaxString] = Optional.Absent,
    limit: Optional[PositiveInteger] = Optional.Absent,
    nextToken: Optional[NonZeroAndMaxString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribePlayerSessionsRequest = {
    import DescribePlayerSessionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribePlayerSessionsRequest
      .builder()
      .optionallyWith(
        gameSessionId.map(value =>
          ArnStringModel.unwrap(value): java.lang.String
        )
      )(_.gameSessionId)
      .optionallyWith(
        playerId.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.playerId)
      .optionallyWith(
        playerSessionId.map(value =>
          PlayerSessionId.unwrap(value): java.lang.String
        )
      )(_.playerSessionId)
      .optionallyWith(
        playerSessionStatusFilter.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.playerSessionStatusFilter)
      .optionallyWith(
        limit.map(value => PositiveInteger.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribePlayerSessionsRequest.ReadOnly =
    zio.aws.gamelift.model.DescribePlayerSessionsRequest.wrap(buildAwsValue())
}
object DescribePlayerSessionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribePlayerSessionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribePlayerSessionsRequest =
      zio.aws.gamelift.model.DescribePlayerSessionsRequest(
        gameSessionId.map(value => value),
        playerId.map(value => value),
        playerSessionId.map(value => value),
        playerSessionStatusFilter.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def gameSessionId: Optional[ArnStringModel]
    def playerId: Optional[NonZeroAndMaxString]
    def playerSessionId: Optional[PlayerSessionId]
    def playerSessionStatusFilter: Optional[NonZeroAndMaxString]
    def limit: Optional[PositiveInteger]
    def nextToken: Optional[NonZeroAndMaxString]
    def getGameSessionId: ZIO[Any, AwsError, ArnStringModel] =
      AwsError.unwrapOptionField("gameSessionId", gameSessionId)
    def getPlayerId: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("playerId", playerId)
    def getPlayerSessionId: ZIO[Any, AwsError, PlayerSessionId] =
      AwsError.unwrapOptionField("playerSessionId", playerSessionId)
    def getPlayerSessionStatusFilter: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField(
        "playerSessionStatusFilter",
        playerSessionStatusFilter
      )
    def getLimit: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribePlayerSessionsRequest
  ) extends zio.aws.gamelift.model.DescribePlayerSessionsRequest.ReadOnly {
    override val gameSessionId: Optional[ArnStringModel] = zio.aws.core.internal
      .optionalFromNullable(impl.gameSessionId())
      .map(value => zio.aws.gamelift.model.primitives.ArnStringModel(value))
    override val playerId: Optional[NonZeroAndMaxString] = zio.aws.core.internal
      .optionalFromNullable(impl.playerId())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val playerSessionId: Optional[PlayerSessionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.playerSessionId())
        .map(value => zio.aws.gamelift.model.primitives.PlayerSessionId(value))
    override val playerSessionStatusFilter: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.playerSessionStatusFilter())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
    override val limit: Optional[PositiveInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.gamelift.model.primitives.PositiveInteger(value))
    override val nextToken: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribePlayerSessionsRequest
  ): zio.aws.gamelift.model.DescribePlayerSessionsRequest.ReadOnly =
    new Wrapper(impl)
}
