package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.{
  LocationStringModel,
  NonZeroAndMaxString,
  PositiveInteger,
  FleetIdOrArn
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeScalingPoliciesRequest(
    fleetId: FleetIdOrArn,
    statusFilter: Optional[zio.aws.gamelift.model.ScalingStatusType] =
      Optional.Absent,
    limit: Optional[PositiveInteger] = Optional.Absent,
    nextToken: Optional[NonZeroAndMaxString] = Optional.Absent,
    location: Optional[LocationStringModel] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesRequest = {
    import DescribeScalingPoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesRequest
      .builder()
      .fleetId(FleetIdOrArn.unwrap(fleetId): java.lang.String)
      .optionallyWith(statusFilter.map(value => value.unwrap))(_.statusFilter)
      .optionallyWith(
        limit.map(value => PositiveInteger.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .optionallyWith(
        location.map(value =>
          LocationStringModel.unwrap(value): java.lang.String
        )
      )(_.location)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribeScalingPoliciesRequest.ReadOnly =
    zio.aws.gamelift.model.DescribeScalingPoliciesRequest.wrap(buildAwsValue())
}
object DescribeScalingPoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribeScalingPoliciesRequest =
      zio.aws.gamelift.model.DescribeScalingPoliciesRequest(
        fleetId,
        statusFilter.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value),
        location.map(value => value)
      )
    def fleetId: FleetIdOrArn
    def statusFilter: Optional[zio.aws.gamelift.model.ScalingStatusType]
    def limit: Optional[PositiveInteger]
    def nextToken: Optional[NonZeroAndMaxString]
    def location: Optional[LocationStringModel]
    def getFleetId: ZIO[Any, Nothing, FleetIdOrArn] = ZIO.succeed(fleetId)
    def getStatusFilter
        : ZIO[Any, AwsError, zio.aws.gamelift.model.ScalingStatusType] =
      AwsError.unwrapOptionField("statusFilter", statusFilter)
    def getLimit: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getLocation: ZIO[Any, AwsError, LocationStringModel] =
      AwsError.unwrapOptionField("location", location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesRequest
  ) extends zio.aws.gamelift.model.DescribeScalingPoliciesRequest.ReadOnly {
    override val fleetId: FleetIdOrArn =
      zio.aws.gamelift.model.primitives.FleetIdOrArn(impl.fleetId())
    override val statusFilter
        : Optional[zio.aws.gamelift.model.ScalingStatusType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusFilter())
        .map(value => zio.aws.gamelift.model.ScalingStatusType.wrap(value))
    override val limit: Optional[PositiveInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.gamelift.model.primitives.PositiveInteger(value))
    override val nextToken: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
    override val location: Optional[LocationStringModel] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value =>
        zio.aws.gamelift.model.primitives.LocationStringModel(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesRequest
  ): zio.aws.gamelift.model.DescribeScalingPoliciesRequest.ReadOnly =
    new Wrapper(impl)
}
