package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.WholeNumber
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class EC2InstanceCounts(
    desired: Optional[WholeNumber] = Optional.Absent,
    minimum: Optional[WholeNumber] = Optional.Absent,
    maximum: Optional[WholeNumber] = Optional.Absent,
    pending: Optional[WholeNumber] = Optional.Absent,
    active: Optional[WholeNumber] = Optional.Absent,
    idle: Optional[WholeNumber] = Optional.Absent,
    terminating: Optional[WholeNumber] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.EC2InstanceCounts = {
    import EC2InstanceCounts.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.EC2InstanceCounts
      .builder()
      .optionallyWith(desired.map(value => WholeNumber.unwrap(value): Integer))(
        _.desired
      )
      .optionallyWith(minimum.map(value => WholeNumber.unwrap(value): Integer))(
        _.minimum
      )
      .optionallyWith(maximum.map(value => WholeNumber.unwrap(value): Integer))(
        _.maximum
      )
      .optionallyWith(pending.map(value => WholeNumber.unwrap(value): Integer))(
        _.pending
      )
      .optionallyWith(active.map(value => WholeNumber.unwrap(value): Integer))(
        _.active
      )
      .optionallyWith(idle.map(value => WholeNumber.unwrap(value): Integer))(
        _.idle
      )
      .optionallyWith(
        terminating.map(value => WholeNumber.unwrap(value): Integer)
      )(_.terminating)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.EC2InstanceCounts.ReadOnly =
    zio.aws.gamelift.model.EC2InstanceCounts.wrap(buildAwsValue())
}
object EC2InstanceCounts {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.EC2InstanceCounts
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.EC2InstanceCounts =
      zio.aws.gamelift.model.EC2InstanceCounts(
        desired.map(value => value),
        minimum.map(value => value),
        maximum.map(value => value),
        pending.map(value => value),
        active.map(value => value),
        idle.map(value => value),
        terminating.map(value => value)
      )
    def desired: Optional[WholeNumber]
    def minimum: Optional[WholeNumber]
    def maximum: Optional[WholeNumber]
    def pending: Optional[WholeNumber]
    def active: Optional[WholeNumber]
    def idle: Optional[WholeNumber]
    def terminating: Optional[WholeNumber]
    def getDesired: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("desired", desired)
    def getMinimum: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("minimum", minimum)
    def getMaximum: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("maximum", maximum)
    def getPending: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("pending", pending)
    def getActive: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("active", active)
    def getIdle: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("idle", idle)
    def getTerminating: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("terminating", terminating)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.EC2InstanceCounts
  ) extends zio.aws.gamelift.model.EC2InstanceCounts.ReadOnly {
    override val desired: Optional[WholeNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.desired())
      .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
    override val minimum: Optional[WholeNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.minimum())
      .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
    override val maximum: Optional[WholeNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.maximum())
      .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
    override val pending: Optional[WholeNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.pending())
      .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
    override val active: Optional[WholeNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.active())
      .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
    override val idle: Optional[WholeNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.idle())
      .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
    override val terminating: Optional[WholeNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.terminating())
      .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.EC2InstanceCounts
  ): zio.aws.gamelift.model.EC2InstanceCounts.ReadOnly = new Wrapper(impl)
}
