package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.{
  LocationStringModel,
  FleetArn,
  FleetId
}
import scala.jdk.CollectionConverters._
final case class FleetCapacity(
    fleetId: Optional[FleetId] = Optional.Absent,
    fleetArn: Optional[FleetArn] = Optional.Absent,
    instanceType: Optional[zio.aws.gamelift.model.EC2InstanceType] =
      Optional.Absent,
    instanceCounts: Optional[zio.aws.gamelift.model.EC2InstanceCounts] =
      Optional.Absent,
    location: Optional[LocationStringModel] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.FleetCapacity = {
    import FleetCapacity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.FleetCapacity
      .builder()
      .optionallyWith(
        fleetId.map(value => FleetId.unwrap(value): java.lang.String)
      )(_.fleetId)
      .optionallyWith(
        fleetArn.map(value => FleetArn.unwrap(value): java.lang.String)
      )(_.fleetArn)
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(instanceCounts.map(value => value.buildAwsValue()))(
        _.instanceCounts
      )
      .optionallyWith(
        location.map(value =>
          LocationStringModel.unwrap(value): java.lang.String
        )
      )(_.location)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.FleetCapacity.ReadOnly =
    zio.aws.gamelift.model.FleetCapacity.wrap(buildAwsValue())
}
object FleetCapacity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.FleetCapacity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.FleetCapacity =
      zio.aws.gamelift.model.FleetCapacity(
        fleetId.map(value => value),
        fleetArn.map(value => value),
        instanceType.map(value => value),
        instanceCounts.map(value => value.asEditable),
        location.map(value => value)
      )
    def fleetId: Optional[FleetId]
    def fleetArn: Optional[FleetArn]
    def instanceType: Optional[zio.aws.gamelift.model.EC2InstanceType]
    def instanceCounts
        : Optional[zio.aws.gamelift.model.EC2InstanceCounts.ReadOnly]
    def location: Optional[LocationStringModel]
    def getFleetId: ZIO[Any, AwsError, FleetId] =
      AwsError.unwrapOptionField("fleetId", fleetId)
    def getFleetArn: ZIO[Any, AwsError, FleetArn] =
      AwsError.unwrapOptionField("fleetArn", fleetArn)
    def getInstanceType
        : ZIO[Any, AwsError, zio.aws.gamelift.model.EC2InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getInstanceCounts: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.EC2InstanceCounts.ReadOnly
    ] = AwsError.unwrapOptionField("instanceCounts", instanceCounts)
    def getLocation: ZIO[Any, AwsError, LocationStringModel] =
      AwsError.unwrapOptionField("location", location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.FleetCapacity
  ) extends zio.aws.gamelift.model.FleetCapacity.ReadOnly {
    override val fleetId: Optional[FleetId] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetId())
      .map(value => zio.aws.gamelift.model.primitives.FleetId(value))
    override val fleetArn: Optional[FleetArn] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetArn())
      .map(value => zio.aws.gamelift.model.primitives.FleetArn(value))
    override val instanceType
        : Optional[zio.aws.gamelift.model.EC2InstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value => zio.aws.gamelift.model.EC2InstanceType.wrap(value))
    override val instanceCounts
        : Optional[zio.aws.gamelift.model.EC2InstanceCounts.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceCounts())
        .map(value => zio.aws.gamelift.model.EC2InstanceCounts.wrap(value))
    override val location: Optional[LocationStringModel] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value =>
        zio.aws.gamelift.model.primitives.LocationStringModel(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.FleetCapacity
  ): zio.aws.gamelift.model.FleetCapacity.ReadOnly = new Wrapper(impl)
}
