package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.{
  GameServerGroupArn,
  Timestamp,
  GameServerData,
  GameServerGroupName,
  GameServerId,
  GameServerConnectionInfo,
  GameServerInstanceId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GameServer(
    gameServerGroupName: Optional[GameServerGroupName] = Optional.Absent,
    gameServerGroupArn: Optional[GameServerGroupArn] = Optional.Absent,
    gameServerId: Optional[GameServerId] = Optional.Absent,
    instanceId: Optional[GameServerInstanceId] = Optional.Absent,
    connectionInfo: Optional[GameServerConnectionInfo] = Optional.Absent,
    gameServerData: Optional[GameServerData] = Optional.Absent,
    claimStatus: Optional[zio.aws.gamelift.model.GameServerClaimStatus] =
      Optional.Absent,
    utilizationStatus: Optional[
      zio.aws.gamelift.model.GameServerUtilizationStatus
    ] = Optional.Absent,
    registrationTime: Optional[Timestamp] = Optional.Absent,
    lastClaimTime: Optional[Timestamp] = Optional.Absent,
    lastHealthCheckTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.GameServer = {
    import GameServer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.GameServer
      .builder()
      .optionallyWith(
        gameServerGroupName.map(value =>
          GameServerGroupName.unwrap(value): java.lang.String
        )
      )(_.gameServerGroupName)
      .optionallyWith(
        gameServerGroupArn.map(value =>
          GameServerGroupArn.unwrap(value): java.lang.String
        )
      )(_.gameServerGroupArn)
      .optionallyWith(
        gameServerId.map(value => GameServerId.unwrap(value): java.lang.String)
      )(_.gameServerId)
      .optionallyWith(
        instanceId.map(value =>
          GameServerInstanceId.unwrap(value): java.lang.String
        )
      )(_.instanceId)
      .optionallyWith(
        connectionInfo.map(value =>
          GameServerConnectionInfo.unwrap(value): java.lang.String
        )
      )(_.connectionInfo)
      .optionallyWith(
        gameServerData.map(value =>
          GameServerData.unwrap(value): java.lang.String
        )
      )(_.gameServerData)
      .optionallyWith(claimStatus.map(value => value.unwrap))(_.claimStatus)
      .optionallyWith(utilizationStatus.map(value => value.unwrap))(
        _.utilizationStatus
      )
      .optionallyWith(
        registrationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.registrationTime)
      .optionallyWith(
        lastClaimTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastClaimTime)
      .optionallyWith(
        lastHealthCheckTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastHealthCheckTime)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.GameServer.ReadOnly =
    zio.aws.gamelift.model.GameServer.wrap(buildAwsValue())
}
object GameServer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.GameServer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.GameServer =
      zio.aws.gamelift.model.GameServer(
        gameServerGroupName.map(value => value),
        gameServerGroupArn.map(value => value),
        gameServerId.map(value => value),
        instanceId.map(value => value),
        connectionInfo.map(value => value),
        gameServerData.map(value => value),
        claimStatus.map(value => value),
        utilizationStatus.map(value => value),
        registrationTime.map(value => value),
        lastClaimTime.map(value => value),
        lastHealthCheckTime.map(value => value)
      )
    def gameServerGroupName: Optional[GameServerGroupName]
    def gameServerGroupArn: Optional[GameServerGroupArn]
    def gameServerId: Optional[GameServerId]
    def instanceId: Optional[GameServerInstanceId]
    def connectionInfo: Optional[GameServerConnectionInfo]
    def gameServerData: Optional[GameServerData]
    def claimStatus: Optional[zio.aws.gamelift.model.GameServerClaimStatus]
    def utilizationStatus
        : Optional[zio.aws.gamelift.model.GameServerUtilizationStatus]
    def registrationTime: Optional[Timestamp]
    def lastClaimTime: Optional[Timestamp]
    def lastHealthCheckTime: Optional[Timestamp]
    def getGameServerGroupName: ZIO[Any, AwsError, GameServerGroupName] =
      AwsError.unwrapOptionField("gameServerGroupName", gameServerGroupName)
    def getGameServerGroupArn: ZIO[Any, AwsError, GameServerGroupArn] =
      AwsError.unwrapOptionField("gameServerGroupArn", gameServerGroupArn)
    def getGameServerId: ZIO[Any, AwsError, GameServerId] =
      AwsError.unwrapOptionField("gameServerId", gameServerId)
    def getInstanceId: ZIO[Any, AwsError, GameServerInstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getConnectionInfo: ZIO[Any, AwsError, GameServerConnectionInfo] =
      AwsError.unwrapOptionField("connectionInfo", connectionInfo)
    def getGameServerData: ZIO[Any, AwsError, GameServerData] =
      AwsError.unwrapOptionField("gameServerData", gameServerData)
    def getClaimStatus
        : ZIO[Any, AwsError, zio.aws.gamelift.model.GameServerClaimStatus] =
      AwsError.unwrapOptionField("claimStatus", claimStatus)
    def getUtilizationStatus: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.GameServerUtilizationStatus
    ] = AwsError.unwrapOptionField("utilizationStatus", utilizationStatus)
    def getRegistrationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("registrationTime", registrationTime)
    def getLastClaimTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastClaimTime", lastClaimTime)
    def getLastHealthCheckTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastHealthCheckTime", lastHealthCheckTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.GameServer
  ) extends zio.aws.gamelift.model.GameServer.ReadOnly {
    override val gameServerGroupName: Optional[GameServerGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameServerGroupName())
        .map(value =>
          zio.aws.gamelift.model.primitives.GameServerGroupName(value)
        )
    override val gameServerGroupArn: Optional[GameServerGroupArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameServerGroupArn())
        .map(value =>
          zio.aws.gamelift.model.primitives.GameServerGroupArn(value)
        )
    override val gameServerId: Optional[GameServerId] = zio.aws.core.internal
      .optionalFromNullable(impl.gameServerId())
      .map(value => zio.aws.gamelift.model.primitives.GameServerId(value))
    override val instanceId: Optional[GameServerInstanceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceId())
        .map(value =>
          zio.aws.gamelift.model.primitives.GameServerInstanceId(value)
        )
    override val connectionInfo: Optional[GameServerConnectionInfo] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionInfo())
        .map(value =>
          zio.aws.gamelift.model.primitives.GameServerConnectionInfo(value)
        )
    override val gameServerData: Optional[GameServerData] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameServerData())
        .map(value => zio.aws.gamelift.model.primitives.GameServerData(value))
    override val claimStatus
        : Optional[zio.aws.gamelift.model.GameServerClaimStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.claimStatus())
        .map(value => zio.aws.gamelift.model.GameServerClaimStatus.wrap(value))
    override val utilizationStatus
        : Optional[zio.aws.gamelift.model.GameServerUtilizationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.utilizationStatus())
        .map(value =>
          zio.aws.gamelift.model.GameServerUtilizationStatus.wrap(value)
        )
    override val registrationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.registrationTime())
      .map(value => zio.aws.gamelift.model.primitives.Timestamp(value))
    override val lastClaimTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastClaimTime())
      .map(value => zio.aws.gamelift.model.primitives.Timestamp(value))
    override val lastHealthCheckTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastHealthCheckTime())
        .map(value => zio.aws.gamelift.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.GameServer
  ): zio.aws.gamelift.model.GameServer.ReadOnly = new Wrapper(impl)
}
