package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.{
  IamRoleArn,
  AutoScalingGroupArn,
  GameServerGroupArn,
  Timestamp,
  GameServerGroupName,
  NonZeroAndMaxString
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GameServerGroup(
    gameServerGroupName: Optional[GameServerGroupName] = Optional.Absent,
    gameServerGroupArn: Optional[GameServerGroupArn] = Optional.Absent,
    roleArn: Optional[IamRoleArn] = Optional.Absent,
    instanceDefinitions: Optional[
      Iterable[zio.aws.gamelift.model.InstanceDefinition]
    ] = Optional.Absent,
    balancingStrategy: Optional[zio.aws.gamelift.model.BalancingStrategy] =
      Optional.Absent,
    gameServerProtectionPolicy: Optional[
      zio.aws.gamelift.model.GameServerProtectionPolicy
    ] = Optional.Absent,
    autoScalingGroupArn: Optional[AutoScalingGroupArn] = Optional.Absent,
    status: Optional[zio.aws.gamelift.model.GameServerGroupStatus] =
      Optional.Absent,
    statusReason: Optional[NonZeroAndMaxString] = Optional.Absent,
    suspendedActions: Optional[
      Iterable[zio.aws.gamelift.model.GameServerGroupAction]
    ] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastUpdatedTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.GameServerGroup = {
    import GameServerGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.GameServerGroup
      .builder()
      .optionallyWith(
        gameServerGroupName.map(value =>
          GameServerGroupName.unwrap(value): java.lang.String
        )
      )(_.gameServerGroupName)
      .optionallyWith(
        gameServerGroupArn.map(value =>
          GameServerGroupArn.unwrap(value): java.lang.String
        )
      )(_.gameServerGroupArn)
      .optionallyWith(
        roleArn.map(value => IamRoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        instanceDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceDefinitions)
      .optionallyWith(balancingStrategy.map(value => value.unwrap))(
        _.balancingStrategy
      )
      .optionallyWith(gameServerProtectionPolicy.map(value => value.unwrap))(
        _.gameServerProtectionPolicy
      )
      .optionallyWith(
        autoScalingGroupArn.map(value =>
          AutoScalingGroupArn.unwrap(value): java.lang.String
        )
      )(_.autoScalingGroupArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusReason.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.statusReason)
      .optionallyWith(
        suspendedActions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.suspendedActionsWithStrings)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastUpdatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.GameServerGroup.ReadOnly =
    zio.aws.gamelift.model.GameServerGroup.wrap(buildAwsValue())
}
object GameServerGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.GameServerGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.GameServerGroup =
      zio.aws.gamelift.model.GameServerGroup(
        gameServerGroupName.map(value => value),
        gameServerGroupArn.map(value => value),
        roleArn.map(value => value),
        instanceDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        balancingStrategy.map(value => value),
        gameServerProtectionPolicy.map(value => value),
        autoScalingGroupArn.map(value => value),
        status.map(value => value),
        statusReason.map(value => value),
        suspendedActions.map(value => value),
        creationTime.map(value => value),
        lastUpdatedTime.map(value => value)
      )
    def gameServerGroupName: Optional[GameServerGroupName]
    def gameServerGroupArn: Optional[GameServerGroupArn]
    def roleArn: Optional[IamRoleArn]
    def instanceDefinitions
        : Optional[List[zio.aws.gamelift.model.InstanceDefinition.ReadOnly]]
    def balancingStrategy: Optional[zio.aws.gamelift.model.BalancingStrategy]
    def gameServerProtectionPolicy
        : Optional[zio.aws.gamelift.model.GameServerProtectionPolicy]
    def autoScalingGroupArn: Optional[AutoScalingGroupArn]
    def status: Optional[zio.aws.gamelift.model.GameServerGroupStatus]
    def statusReason: Optional[NonZeroAndMaxString]
    def suspendedActions
        : Optional[List[zio.aws.gamelift.model.GameServerGroupAction]]
    def creationTime: Optional[Timestamp]
    def lastUpdatedTime: Optional[Timestamp]
    def getGameServerGroupName: ZIO[Any, AwsError, GameServerGroupName] =
      AwsError.unwrapOptionField("gameServerGroupName", gameServerGroupName)
    def getGameServerGroupArn: ZIO[Any, AwsError, GameServerGroupArn] =
      AwsError.unwrapOptionField("gameServerGroupArn", gameServerGroupArn)
    def getRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getInstanceDefinitions: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.InstanceDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField("instanceDefinitions", instanceDefinitions)
    def getBalancingStrategy
        : ZIO[Any, AwsError, zio.aws.gamelift.model.BalancingStrategy] =
      AwsError.unwrapOptionField("balancingStrategy", balancingStrategy)
    def getGameServerProtectionPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.GameServerProtectionPolicy
    ] = AwsError.unwrapOptionField(
      "gameServerProtectionPolicy",
      gameServerProtectionPolicy
    )
    def getAutoScalingGroupArn: ZIO[Any, AwsError, AutoScalingGroupArn] =
      AwsError.unwrapOptionField("autoScalingGroupArn", autoScalingGroupArn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.gamelift.model.GameServerGroupStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusReason: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getSuspendedActions: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.GameServerGroupAction
    ]] = AwsError.unwrapOptionField("suspendedActions", suspendedActions)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastUpdatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.GameServerGroup
  ) extends zio.aws.gamelift.model.GameServerGroup.ReadOnly {
    override val gameServerGroupName: Optional[GameServerGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameServerGroupName())
        .map(value =>
          zio.aws.gamelift.model.primitives.GameServerGroupName(value)
        )
    override val gameServerGroupArn: Optional[GameServerGroupArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameServerGroupArn())
        .map(value =>
          zio.aws.gamelift.model.primitives.GameServerGroupArn(value)
        )
    override val roleArn: Optional[IamRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.gamelift.model.primitives.IamRoleArn(value))
    override val instanceDefinitions
        : Optional[List[zio.aws.gamelift.model.InstanceDefinition.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceDefinitions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.InstanceDefinition.wrap(item)
          }.toList
        )
    override val balancingStrategy
        : Optional[zio.aws.gamelift.model.BalancingStrategy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.balancingStrategy())
        .map(value => zio.aws.gamelift.model.BalancingStrategy.wrap(value))
    override val gameServerProtectionPolicy
        : Optional[zio.aws.gamelift.model.GameServerProtectionPolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameServerProtectionPolicy())
        .map(value =>
          zio.aws.gamelift.model.GameServerProtectionPolicy.wrap(value)
        )
    override val autoScalingGroupArn: Optional[AutoScalingGroupArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoScalingGroupArn())
        .map(value =>
          zio.aws.gamelift.model.primitives.AutoScalingGroupArn(value)
        )
    override val status
        : Optional[zio.aws.gamelift.model.GameServerGroupStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.gamelift.model.GameServerGroupStatus.wrap(value))
    override val statusReason: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusReason())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
    override val suspendedActions
        : Optional[List[zio.aws.gamelift.model.GameServerGroupAction]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suspendedActions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.GameServerGroupAction.wrap(item)
          }.toList
        )
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.gamelift.model.primitives.Timestamp(value))
    override val lastUpdatedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTime())
      .map(value => zio.aws.gamelift.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.GameServerGroup
  ): zio.aws.gamelift.model.GameServerGroup.ReadOnly = new Wrapper(impl)
}
