package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.{
  GameServerInstanceId,
  GameServerGroupArn,
  GameServerGroupName
}
import scala.jdk.CollectionConverters._
final case class GameServerInstance(
    gameServerGroupName: Optional[GameServerGroupName] = Optional.Absent,
    gameServerGroupArn: Optional[GameServerGroupArn] = Optional.Absent,
    instanceId: Optional[GameServerInstanceId] = Optional.Absent,
    instanceStatus: Optional[zio.aws.gamelift.model.GameServerInstanceStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.GameServerInstance = {
    import GameServerInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.GameServerInstance
      .builder()
      .optionallyWith(
        gameServerGroupName.map(value =>
          GameServerGroupName.unwrap(value): java.lang.String
        )
      )(_.gameServerGroupName)
      .optionallyWith(
        gameServerGroupArn.map(value =>
          GameServerGroupArn.unwrap(value): java.lang.String
        )
      )(_.gameServerGroupArn)
      .optionallyWith(
        instanceId.map(value =>
          GameServerInstanceId.unwrap(value): java.lang.String
        )
      )(_.instanceId)
      .optionallyWith(instanceStatus.map(value => value.unwrap))(
        _.instanceStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.GameServerInstance.ReadOnly =
    zio.aws.gamelift.model.GameServerInstance.wrap(buildAwsValue())
}
object GameServerInstance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.GameServerInstance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.GameServerInstance =
      zio.aws.gamelift.model.GameServerInstance(
        gameServerGroupName.map(value => value),
        gameServerGroupArn.map(value => value),
        instanceId.map(value => value),
        instanceStatus.map(value => value)
      )
    def gameServerGroupName: Optional[GameServerGroupName]
    def gameServerGroupArn: Optional[GameServerGroupArn]
    def instanceId: Optional[GameServerInstanceId]
    def instanceStatus
        : Optional[zio.aws.gamelift.model.GameServerInstanceStatus]
    def getGameServerGroupName: ZIO[Any, AwsError, GameServerGroupName] =
      AwsError.unwrapOptionField("gameServerGroupName", gameServerGroupName)
    def getGameServerGroupArn: ZIO[Any, AwsError, GameServerGroupArn] =
      AwsError.unwrapOptionField("gameServerGroupArn", gameServerGroupArn)
    def getInstanceId: ZIO[Any, AwsError, GameServerInstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getInstanceStatus
        : ZIO[Any, AwsError, zio.aws.gamelift.model.GameServerInstanceStatus] =
      AwsError.unwrapOptionField("instanceStatus", instanceStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.GameServerInstance
  ) extends zio.aws.gamelift.model.GameServerInstance.ReadOnly {
    override val gameServerGroupName: Optional[GameServerGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameServerGroupName())
        .map(value =>
          zio.aws.gamelift.model.primitives.GameServerGroupName(value)
        )
    override val gameServerGroupArn: Optional[GameServerGroupArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameServerGroupArn())
        .map(value =>
          zio.aws.gamelift.model.primitives.GameServerGroupArn(value)
        )
    override val instanceId: Optional[GameServerInstanceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceId())
        .map(value =>
          zio.aws.gamelift.model.primitives.GameServerInstanceId(value)
        )
    override val instanceStatus
        : Optional[zio.aws.gamelift.model.GameServerInstanceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceStatus())
        .map(value =>
          zio.aws.gamelift.model.GameServerInstanceStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.GameServerInstance
  ): zio.aws.gamelift.model.GameServerInstance.ReadOnly = new Wrapper(impl)
}
