package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.{
  GameSessionQueueArn,
  GameSessionQueueName,
  WholeNumber,
  QueueCustomEventData,
  QueueSnsArnStringModel
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GameSessionQueue(
    name: Optional[GameSessionQueueName] = Optional.Absent,
    gameSessionQueueArn: Optional[GameSessionQueueArn] = Optional.Absent,
    timeoutInSeconds: Optional[WholeNumber] = Optional.Absent,
    playerLatencyPolicies: Optional[
      Iterable[zio.aws.gamelift.model.PlayerLatencyPolicy]
    ] = Optional.Absent,
    destinations: Optional[
      Iterable[zio.aws.gamelift.model.GameSessionQueueDestination]
    ] = Optional.Absent,
    filterConfiguration: Optional[zio.aws.gamelift.model.FilterConfiguration] =
      Optional.Absent,
    priorityConfiguration: Optional[
      zio.aws.gamelift.model.PriorityConfiguration
    ] = Optional.Absent,
    customEventData: Optional[QueueCustomEventData] = Optional.Absent,
    notificationTarget: Optional[QueueSnsArnStringModel] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.GameSessionQueue = {
    import GameSessionQueue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.GameSessionQueue
      .builder()
      .optionallyWith(
        name.map(value => GameSessionQueueName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        gameSessionQueueArn.map(value =>
          GameSessionQueueArn.unwrap(value): java.lang.String
        )
      )(_.gameSessionQueueArn)
      .optionallyWith(
        timeoutInSeconds.map(value => WholeNumber.unwrap(value): Integer)
      )(_.timeoutInSeconds)
      .optionallyWith(
        playerLatencyPolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.playerLatencyPolicies)
      .optionallyWith(
        destinations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.destinations)
      .optionallyWith(filterConfiguration.map(value => value.buildAwsValue()))(
        _.filterConfiguration
      )
      .optionallyWith(
        priorityConfiguration.map(value => value.buildAwsValue())
      )(_.priorityConfiguration)
      .optionallyWith(
        customEventData.map(value =>
          QueueCustomEventData.unwrap(value): java.lang.String
        )
      )(_.customEventData)
      .optionallyWith(
        notificationTarget.map(value =>
          QueueSnsArnStringModel.unwrap(value): java.lang.String
        )
      )(_.notificationTarget)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.GameSessionQueue.ReadOnly =
    zio.aws.gamelift.model.GameSessionQueue.wrap(buildAwsValue())
}
object GameSessionQueue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.GameSessionQueue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.GameSessionQueue =
      zio.aws.gamelift.model.GameSessionQueue(
        name.map(value => value),
        gameSessionQueueArn.map(value => value),
        timeoutInSeconds.map(value => value),
        playerLatencyPolicies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        destinations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        filterConfiguration.map(value => value.asEditable),
        priorityConfiguration.map(value => value.asEditable),
        customEventData.map(value => value),
        notificationTarget.map(value => value)
      )
    def name: Optional[GameSessionQueueName]
    def gameSessionQueueArn: Optional[GameSessionQueueArn]
    def timeoutInSeconds: Optional[WholeNumber]
    def playerLatencyPolicies
        : Optional[List[zio.aws.gamelift.model.PlayerLatencyPolicy.ReadOnly]]
    def destinations: Optional[
      List[zio.aws.gamelift.model.GameSessionQueueDestination.ReadOnly]
    ]
    def filterConfiguration
        : Optional[zio.aws.gamelift.model.FilterConfiguration.ReadOnly]
    def priorityConfiguration
        : Optional[zio.aws.gamelift.model.PriorityConfiguration.ReadOnly]
    def customEventData: Optional[QueueCustomEventData]
    def notificationTarget: Optional[QueueSnsArnStringModel]
    def getName: ZIO[Any, AwsError, GameSessionQueueName] =
      AwsError.unwrapOptionField("name", name)
    def getGameSessionQueueArn: ZIO[Any, AwsError, GameSessionQueueArn] =
      AwsError.unwrapOptionField("gameSessionQueueArn", gameSessionQueueArn)
    def getTimeoutInSeconds: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("timeoutInSeconds", timeoutInSeconds)
    def getPlayerLatencyPolicies: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.PlayerLatencyPolicy.ReadOnly
    ]] =
      AwsError.unwrapOptionField("playerLatencyPolicies", playerLatencyPolicies)
    def getDestinations: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.GameSessionQueueDestination.ReadOnly
    ]] = AwsError.unwrapOptionField("destinations", destinations)
    def getFilterConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.FilterConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("filterConfiguration", filterConfiguration)
    def getPriorityConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.PriorityConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("priorityConfiguration", priorityConfiguration)
    def getCustomEventData: ZIO[Any, AwsError, QueueCustomEventData] =
      AwsError.unwrapOptionField("customEventData", customEventData)
    def getNotificationTarget: ZIO[Any, AwsError, QueueSnsArnStringModel] =
      AwsError.unwrapOptionField("notificationTarget", notificationTarget)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.GameSessionQueue
  ) extends zio.aws.gamelift.model.GameSessionQueue.ReadOnly {
    override val name: Optional[GameSessionQueueName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.gamelift.model.primitives.GameSessionQueueName(value)
      )
    override val gameSessionQueueArn: Optional[GameSessionQueueArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameSessionQueueArn())
        .map(value =>
          zio.aws.gamelift.model.primitives.GameSessionQueueArn(value)
        )
    override val timeoutInSeconds: Optional[WholeNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.timeoutInSeconds())
      .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
    override val playerLatencyPolicies
        : Optional[List[zio.aws.gamelift.model.PlayerLatencyPolicy.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.playerLatencyPolicies())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.PlayerLatencyPolicy.wrap(item)
          }.toList
        )
    override val destinations: Optional[
      List[zio.aws.gamelift.model.GameSessionQueueDestination.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.destinations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.GameSessionQueueDestination.wrap(item)
        }.toList
      )
    override val filterConfiguration
        : Optional[zio.aws.gamelift.model.FilterConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterConfiguration())
        .map(value => zio.aws.gamelift.model.FilterConfiguration.wrap(value))
    override val priorityConfiguration
        : Optional[zio.aws.gamelift.model.PriorityConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.priorityConfiguration())
        .map(value => zio.aws.gamelift.model.PriorityConfiguration.wrap(value))
    override val customEventData: Optional[QueueCustomEventData] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customEventData())
        .map(value =>
          zio.aws.gamelift.model.primitives.QueueCustomEventData(value)
        )
    override val notificationTarget: Optional[QueueSnsArnStringModel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notificationTarget())
        .map(value =>
          zio.aws.gamelift.model.primitives.QueueSnsArnStringModel(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.GameSessionQueue
  ): zio.aws.gamelift.model.GameSessionQueue.ReadOnly = new Wrapper(impl)
}
