package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.ArnStringModel
import scala.jdk.CollectionConverters._
final case class GameSessionQueueDestination(
    destinationArn: Optional[ArnStringModel] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.GameSessionQueueDestination = {
    import GameSessionQueueDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.GameSessionQueueDestination
      .builder()
      .optionallyWith(
        destinationArn.map(value =>
          ArnStringModel.unwrap(value): java.lang.String
        )
      )(_.destinationArn)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.GameSessionQueueDestination.ReadOnly =
    zio.aws.gamelift.model.GameSessionQueueDestination.wrap(buildAwsValue())
}
object GameSessionQueueDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.GameSessionQueueDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.GameSessionQueueDestination =
      zio.aws.gamelift.model
        .GameSessionQueueDestination(destinationArn.map(value => value))
    def destinationArn: Optional[ArnStringModel]
    def getDestinationArn: ZIO[Any, AwsError, ArnStringModel] =
      AwsError.unwrapOptionField("destinationArn", destinationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.GameSessionQueueDestination
  ) extends zio.aws.gamelift.model.GameSessionQueueDestination.ReadOnly {
    override val destinationArn: Optional[ArnStringModel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationArn())
        .map(value => zio.aws.gamelift.model.primitives.ArnStringModel(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.GameSessionQueueDestination
  ): zio.aws.gamelift.model.GameSessionQueueDestination.ReadOnly = new Wrapper(
    impl
  )
}
