package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.{ComputeNameOrArn, FleetIdOrArn}
import scala.jdk.CollectionConverters._
final case class GetComputeAccessRequest(
    fleetId: FleetIdOrArn,
    computeName: ComputeNameOrArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.GetComputeAccessRequest = {
    import GetComputeAccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.GetComputeAccessRequest
      .builder()
      .fleetId(FleetIdOrArn.unwrap(fleetId): java.lang.String)
      .computeName(ComputeNameOrArn.unwrap(computeName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.GetComputeAccessRequest.ReadOnly =
    zio.aws.gamelift.model.GetComputeAccessRequest.wrap(buildAwsValue())
}
object GetComputeAccessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.GetComputeAccessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.GetComputeAccessRequest =
      zio.aws.gamelift.model.GetComputeAccessRequest(fleetId, computeName)
    def fleetId: FleetIdOrArn
    def computeName: ComputeNameOrArn
    def getFleetId: ZIO[Any, Nothing, FleetIdOrArn] = ZIO.succeed(fleetId)
    def getComputeName: ZIO[Any, Nothing, ComputeNameOrArn] =
      ZIO.succeed(computeName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.GetComputeAccessRequest
  ) extends zio.aws.gamelift.model.GetComputeAccessRequest.ReadOnly {
    override val fleetId: FleetIdOrArn =
      zio.aws.gamelift.model.primitives.FleetIdOrArn(impl.fleetId())
    override val computeName: ComputeNameOrArn =
      zio.aws.gamelift.model.primitives.ComputeNameOrArn(impl.computeName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.GetComputeAccessRequest
  ): zio.aws.gamelift.model.GetComputeAccessRequest.ReadOnly = new Wrapper(impl)
}
