package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.WeightedCapacity
import scala.jdk.CollectionConverters._
final case class InstanceDefinition(
    instanceType: zio.aws.gamelift.model.GameServerGroupInstanceType,
    weightedCapacity: Optional[WeightedCapacity] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.InstanceDefinition = {
    import InstanceDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.InstanceDefinition
      .builder()
      .instanceType(instanceType.unwrap)
      .optionallyWith(
        weightedCapacity.map(value =>
          WeightedCapacity.unwrap(value): java.lang.String
        )
      )(_.weightedCapacity)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.InstanceDefinition.ReadOnly =
    zio.aws.gamelift.model.InstanceDefinition.wrap(buildAwsValue())
}
object InstanceDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.InstanceDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.InstanceDefinition =
      zio.aws.gamelift.model
        .InstanceDefinition(instanceType, weightedCapacity.map(value => value))
    def instanceType: zio.aws.gamelift.model.GameServerGroupInstanceType
    def weightedCapacity: Optional[WeightedCapacity]
    def getInstanceType: ZIO[
      Any,
      Nothing,
      zio.aws.gamelift.model.GameServerGroupInstanceType
    ] = ZIO.succeed(instanceType)
    def getWeightedCapacity: ZIO[Any, AwsError, WeightedCapacity] =
      AwsError.unwrapOptionField("weightedCapacity", weightedCapacity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.InstanceDefinition
  ) extends zio.aws.gamelift.model.InstanceDefinition.ReadOnly {
    override val instanceType
        : zio.aws.gamelift.model.GameServerGroupInstanceType =
      zio.aws.gamelift.model.GameServerGroupInstanceType
        .wrap(impl.instanceType())
    override val weightedCapacity: Optional[WeightedCapacity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.weightedCapacity())
        .map(value => zio.aws.gamelift.model.primitives.WeightedCapacity(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.InstanceDefinition
  ): zio.aws.gamelift.model.InstanceDefinition.ReadOnly = new Wrapper(impl)
}
