package zio.aws.gamelift.model
import scala.jdk.CollectionConverters._
sealed trait InstanceStatus {
  def unwrap: software.amazon.awssdk.services.gamelift.model.InstanceStatus
}
object InstanceStatus {
  def wrap(
      value: software.amazon.awssdk.services.gamelift.model.InstanceStatus
  ): zio.aws.gamelift.model.InstanceStatus = value match {
    case software.amazon.awssdk.services.gamelift.model.InstanceStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.gamelift.model.InstanceStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.gamelift.model.InstanceStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.gamelift.model.InstanceStatus.TERMINATING =>
      val r = TERMINATING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.gamelift.model.InstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.InstanceStatus =
      software.amazon.awssdk.services.gamelift.model.InstanceStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.gamelift.model.InstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.InstanceStatus =
      software.amazon.awssdk.services.gamelift.model.InstanceStatus.PENDING
  }
  case object ACTIVE extends zio.aws.gamelift.model.InstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.InstanceStatus =
      software.amazon.awssdk.services.gamelift.model.InstanceStatus.ACTIVE
  }
  case object TERMINATING extends zio.aws.gamelift.model.InstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.InstanceStatus =
      software.amazon.awssdk.services.gamelift.model.InstanceStatus.TERMINATING
  }
}
