package zio.aws.gamelift.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.{NonBlankString, PortNumber}
import scala.jdk.CollectionConverters._
final case class IpPermission(
    fromPort: PortNumber,
    toPort: PortNumber,
    ipRange: NonBlankString,
    protocol: zio.aws.gamelift.model.IpProtocol
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.IpPermission = {
    import IpPermission.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.IpPermission
      .builder()
      .fromPort(PortNumber.unwrap(fromPort): Integer)
      .toPort(PortNumber.unwrap(toPort): Integer)
      .ipRange(NonBlankString.unwrap(ipRange): java.lang.String)
      .protocol(protocol.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.IpPermission.ReadOnly =
    zio.aws.gamelift.model.IpPermission.wrap(buildAwsValue())
}
object IpPermission {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.IpPermission
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.IpPermission =
      zio.aws.gamelift.model.IpPermission(fromPort, toPort, ipRange, protocol)
    def fromPort: PortNumber
    def toPort: PortNumber
    def ipRange: NonBlankString
    def protocol: zio.aws.gamelift.model.IpProtocol
    def getFromPort: ZIO[Any, Nothing, PortNumber] = ZIO.succeed(fromPort)
    def getToPort: ZIO[Any, Nothing, PortNumber] = ZIO.succeed(toPort)
    def getIpRange: ZIO[Any, Nothing, NonBlankString] = ZIO.succeed(ipRange)
    def getProtocol: ZIO[Any, Nothing, zio.aws.gamelift.model.IpProtocol] =
      ZIO.succeed(protocol)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.IpPermission
  ) extends zio.aws.gamelift.model.IpPermission.ReadOnly {
    override val fromPort: PortNumber =
      zio.aws.gamelift.model.primitives.PortNumber(impl.fromPort())
    override val toPort: PortNumber =
      zio.aws.gamelift.model.primitives.PortNumber(impl.toPort())
    override val ipRange: NonBlankString =
      zio.aws.gamelift.model.primitives.NonBlankString(impl.ipRange())
    override val protocol: zio.aws.gamelift.model.IpProtocol =
      zio.aws.gamelift.model.IpProtocol.wrap(impl.protocol())
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.IpPermission
  ): zio.aws.gamelift.model.IpPermission.ReadOnly = new Wrapper(impl)
}
