package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.{
  NonZeroAndMaxString,
  PositiveInteger,
  LocationStringModel,
  FleetIdOrArn
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListComputeRequest(
    fleetId: FleetIdOrArn,
    location: Optional[LocationStringModel] = Optional.Absent,
    limit: Optional[PositiveInteger] = Optional.Absent,
    nextToken: Optional[NonZeroAndMaxString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.ListComputeRequest = {
    import ListComputeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.ListComputeRequest
      .builder()
      .fleetId(FleetIdOrArn.unwrap(fleetId): java.lang.String)
      .optionallyWith(
        location.map(value =>
          LocationStringModel.unwrap(value): java.lang.String
        )
      )(_.location)
      .optionallyWith(
        limit.map(value => PositiveInteger.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.ListComputeRequest.ReadOnly =
    zio.aws.gamelift.model.ListComputeRequest.wrap(buildAwsValue())
}
object ListComputeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.ListComputeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.ListComputeRequest =
      zio.aws.gamelift.model.ListComputeRequest(
        fleetId,
        location.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def fleetId: FleetIdOrArn
    def location: Optional[LocationStringModel]
    def limit: Optional[PositiveInteger]
    def nextToken: Optional[NonZeroAndMaxString]
    def getFleetId: ZIO[Any, Nothing, FleetIdOrArn] = ZIO.succeed(fleetId)
    def getLocation: ZIO[Any, AwsError, LocationStringModel] =
      AwsError.unwrapOptionField("location", location)
    def getLimit: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.ListComputeRequest
  ) extends zio.aws.gamelift.model.ListComputeRequest.ReadOnly {
    override val fleetId: FleetIdOrArn =
      zio.aws.gamelift.model.primitives.FleetIdOrArn(impl.fleetId())
    override val location: Optional[LocationStringModel] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value =>
        zio.aws.gamelift.model.primitives.LocationStringModel(value)
      )
    override val limit: Optional[PositiveInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.gamelift.model.primitives.PositiveInteger(value))
    override val nextToken: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.ListComputeRequest
  ): zio.aws.gamelift.model.ListComputeRequest.ReadOnly = new Wrapper(impl)
}
