package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.NonZeroAndMaxString
import scala.jdk.CollectionConverters._
final case class ListComputeResponse(
    computeList: Optional[Iterable[zio.aws.gamelift.model.Compute]] =
      Optional.Absent,
    nextToken: Optional[NonZeroAndMaxString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.ListComputeResponse = {
    import ListComputeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.ListComputeResponse
      .builder()
      .optionallyWith(
        computeList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.computeList)
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.ListComputeResponse.ReadOnly =
    zio.aws.gamelift.model.ListComputeResponse.wrap(buildAwsValue())
}
object ListComputeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.ListComputeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.ListComputeResponse =
      zio.aws.gamelift.model.ListComputeResponse(
        computeList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def computeList: Optional[List[zio.aws.gamelift.model.Compute.ReadOnly]]
    def nextToken: Optional[NonZeroAndMaxString]
    def getComputeList
        : ZIO[Any, AwsError, List[zio.aws.gamelift.model.Compute.ReadOnly]] =
      AwsError.unwrapOptionField("computeList", computeList)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.ListComputeResponse
  ) extends zio.aws.gamelift.model.ListComputeResponse.ReadOnly {
    override val computeList
        : Optional[List[zio.aws.gamelift.model.Compute.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.computeList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.Compute.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.ListComputeResponse
  ): zio.aws.gamelift.model.ListComputeResponse.ReadOnly = new Wrapper(impl)
}
