package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.{NonEmptyString, PositiveInteger}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListScriptsRequest(
    limit: Optional[PositiveInteger] = Optional.Absent,
    nextToken: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.ListScriptsRequest = {
    import ListScriptsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.ListScriptsRequest
      .builder()
      .optionallyWith(
        limit.map(value => PositiveInteger.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        nextToken.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.ListScriptsRequest.ReadOnly =
    zio.aws.gamelift.model.ListScriptsRequest.wrap(buildAwsValue())
}
object ListScriptsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.ListScriptsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.ListScriptsRequest =
      zio.aws.gamelift.model.ListScriptsRequest(
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def limit: Optional[PositiveInteger]
    def nextToken: Optional[NonEmptyString]
    def getLimit: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.ListScriptsRequest
  ) extends zio.aws.gamelift.model.ListScriptsRequest.ReadOnly {
    override val limit: Optional[PositiveInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.gamelift.model.primitives.PositiveInteger(value))
    override val nextToken: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.gamelift.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.ListScriptsRequest
  ): zio.aws.gamelift.model.ListScriptsRequest.ReadOnly = new Wrapper(impl)
}
