package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.LocationStringModel
import scala.jdk.CollectionConverters._
final case class LocationConfiguration(location: LocationStringModel) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.LocationConfiguration = {
    import LocationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.LocationConfiguration
      .builder()
      .location(LocationStringModel.unwrap(location): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.LocationConfiguration.ReadOnly =
    zio.aws.gamelift.model.LocationConfiguration.wrap(buildAwsValue())
}
object LocationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.LocationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.LocationConfiguration =
      zio.aws.gamelift.model.LocationConfiguration(location)
    def location: LocationStringModel
    def getLocation: ZIO[Any, Nothing, LocationStringModel] =
      ZIO.succeed(location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.LocationConfiguration
  ) extends zio.aws.gamelift.model.LocationConfiguration.ReadOnly {
    override val location: LocationStringModel =
      zio.aws.gamelift.model.primitives.LocationStringModel(impl.location())
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.LocationConfiguration
  ): zio.aws.gamelift.model.LocationConfiguration.ReadOnly = new Wrapper(impl)
}
