package zio.aws.gamelift.model
import scala.jdk.CollectionConverters._
sealed trait LocationUpdateStatus {
  def unwrap
      : software.amazon.awssdk.services.gamelift.model.LocationUpdateStatus
}
object LocationUpdateStatus {
  def wrap(
      value: software.amazon.awssdk.services.gamelift.model.LocationUpdateStatus
  ): zio.aws.gamelift.model.LocationUpdateStatus = value match {
    case software.amazon.awssdk.services.gamelift.model.LocationUpdateStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.gamelift.model.LocationUpdateStatus.PENDING_UPDATE =>
      val r = PENDING_UPDATE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.gamelift.model.LocationUpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.LocationUpdateStatus =
      software.amazon.awssdk.services.gamelift.model.LocationUpdateStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING_UPDATE
      extends zio.aws.gamelift.model.LocationUpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.LocationUpdateStatus =
      software.amazon.awssdk.services.gamelift.model.LocationUpdateStatus.PENDING_UPDATE
  }
}
