package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.{
  StringModel,
  WholeNumber,
  Timestamp,
  MatchmakingConfigurationArn,
  MatchmakingIdStringModel
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class MatchmakingTicket(
    ticketId: Optional[MatchmakingIdStringModel] = Optional.Absent,
    configurationName: Optional[MatchmakingIdStringModel] = Optional.Absent,
    configurationArn: Optional[MatchmakingConfigurationArn] = Optional.Absent,
    status: Optional[zio.aws.gamelift.model.MatchmakingConfigurationStatus] =
      Optional.Absent,
    statusReason: Optional[StringModel] = Optional.Absent,
    statusMessage: Optional[StringModel] = Optional.Absent,
    startTime: Optional[Timestamp] = Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    players: Optional[Iterable[zio.aws.gamelift.model.Player]] =
      Optional.Absent,
    gameSessionConnectionInfo: Optional[
      zio.aws.gamelift.model.GameSessionConnectionInfo
    ] = Optional.Absent,
    estimatedWaitTime: Optional[WholeNumber] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.MatchmakingTicket = {
    import MatchmakingTicket.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.MatchmakingTicket
      .builder()
      .optionallyWith(
        ticketId.map(value =>
          MatchmakingIdStringModel.unwrap(value): java.lang.String
        )
      )(_.ticketId)
      .optionallyWith(
        configurationName.map(value =>
          MatchmakingIdStringModel.unwrap(value): java.lang.String
        )
      )(_.configurationName)
      .optionallyWith(
        configurationArn.map(value =>
          MatchmakingConfigurationArn.unwrap(value): java.lang.String
        )
      )(_.configurationArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusReason.map(value => StringModel.unwrap(value): java.lang.String)
      )(_.statusReason)
      .optionallyWith(
        statusMessage.map(value => StringModel.unwrap(value): java.lang.String)
      )(_.statusMessage)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        players.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.players)
      .optionallyWith(
        gameSessionConnectionInfo.map(value => value.buildAwsValue())
      )(_.gameSessionConnectionInfo)
      .optionallyWith(
        estimatedWaitTime.map(value => WholeNumber.unwrap(value): Integer)
      )(_.estimatedWaitTime)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.MatchmakingTicket.ReadOnly =
    zio.aws.gamelift.model.MatchmakingTicket.wrap(buildAwsValue())
}
object MatchmakingTicket {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.MatchmakingTicket
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.MatchmakingTicket =
      zio.aws.gamelift.model.MatchmakingTicket(
        ticketId.map(value => value),
        configurationName.map(value => value),
        configurationArn.map(value => value),
        status.map(value => value),
        statusReason.map(value => value),
        statusMessage.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        players.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        gameSessionConnectionInfo.map(value => value.asEditable),
        estimatedWaitTime.map(value => value)
      )
    def ticketId: Optional[MatchmakingIdStringModel]
    def configurationName: Optional[MatchmakingIdStringModel]
    def configurationArn: Optional[MatchmakingConfigurationArn]
    def status: Optional[zio.aws.gamelift.model.MatchmakingConfigurationStatus]
    def statusReason: Optional[StringModel]
    def statusMessage: Optional[StringModel]
    def startTime: Optional[Timestamp]
    def endTime: Optional[Timestamp]
    def players: Optional[List[zio.aws.gamelift.model.Player.ReadOnly]]
    def gameSessionConnectionInfo
        : Optional[zio.aws.gamelift.model.GameSessionConnectionInfo.ReadOnly]
    def estimatedWaitTime: Optional[WholeNumber]
    def getTicketId: ZIO[Any, AwsError, MatchmakingIdStringModel] =
      AwsError.unwrapOptionField("ticketId", ticketId)
    def getConfigurationName: ZIO[Any, AwsError, MatchmakingIdStringModel] =
      AwsError.unwrapOptionField("configurationName", configurationName)
    def getConfigurationArn: ZIO[Any, AwsError, MatchmakingConfigurationArn] =
      AwsError.unwrapOptionField("configurationArn", configurationArn)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.MatchmakingConfigurationStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusReason: ZIO[Any, AwsError, StringModel] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getStatusMessage: ZIO[Any, AwsError, StringModel] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getPlayers
        : ZIO[Any, AwsError, List[zio.aws.gamelift.model.Player.ReadOnly]] =
      AwsError.unwrapOptionField("players", players)
    def getGameSessionConnectionInfo: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.GameSessionConnectionInfo.ReadOnly
    ] = AwsError.unwrapOptionField(
      "gameSessionConnectionInfo",
      gameSessionConnectionInfo
    )
    def getEstimatedWaitTime: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("estimatedWaitTime", estimatedWaitTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.MatchmakingTicket
  ) extends zio.aws.gamelift.model.MatchmakingTicket.ReadOnly {
    override val ticketId: Optional[MatchmakingIdStringModel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ticketId())
        .map(value =>
          zio.aws.gamelift.model.primitives.MatchmakingIdStringModel(value)
        )
    override val configurationName: Optional[MatchmakingIdStringModel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationName())
        .map(value =>
          zio.aws.gamelift.model.primitives.MatchmakingIdStringModel(value)
        )
    override val configurationArn: Optional[MatchmakingConfigurationArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationArn())
        .map(value =>
          zio.aws.gamelift.model.primitives.MatchmakingConfigurationArn(value)
        )
    override val status
        : Optional[zio.aws.gamelift.model.MatchmakingConfigurationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.gamelift.model.MatchmakingConfigurationStatus.wrap(value)
        )
    override val statusReason: Optional[StringModel] = zio.aws.core.internal
      .optionalFromNullable(impl.statusReason())
      .map(value => zio.aws.gamelift.model.primitives.StringModel(value))
    override val statusMessage: Optional[StringModel] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => zio.aws.gamelift.model.primitives.StringModel(value))
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.gamelift.model.primitives.Timestamp(value))
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.gamelift.model.primitives.Timestamp(value))
    override val players
        : Optional[List[zio.aws.gamelift.model.Player.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.players())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.Player.wrap(item)
          }.toList
        )
    override val gameSessionConnectionInfo
        : Optional[zio.aws.gamelift.model.GameSessionConnectionInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameSessionConnectionInfo())
        .map(value =>
          zio.aws.gamelift.model.GameSessionConnectionInfo.wrap(value)
        )
    override val estimatedWaitTime: Optional[WholeNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.estimatedWaitTime())
        .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.MatchmakingTicket
  ): zio.aws.gamelift.model.MatchmakingTicket.ReadOnly = new Wrapper(impl)
}
