package zio.aws.gamelift.model
import scala.jdk.CollectionConverters._
sealed trait MetricName {
  def unwrap: software.amazon.awssdk.services.gamelift.model.MetricName
}
object MetricName {
  def wrap(
      value: software.amazon.awssdk.services.gamelift.model.MetricName
  ): zio.aws.gamelift.model.MetricName = value match {
    case software.amazon.awssdk.services.gamelift.model.MetricName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.gamelift.model.MetricName.ACTIVATING_GAME_SESSIONS =>
      val r = ActivatingGameSessions
      r
    case software.amazon.awssdk.services.gamelift.model.MetricName.ACTIVE_GAME_SESSIONS =>
      val r = ActiveGameSessions
      r
    case software.amazon.awssdk.services.gamelift.model.MetricName.ACTIVE_INSTANCES =>
      val r = ActiveInstances
      r
    case software.amazon.awssdk.services.gamelift.model.MetricName.AVAILABLE_GAME_SESSIONS =>
      val r = AvailableGameSessions
      r
    case software.amazon.awssdk.services.gamelift.model.MetricName.AVAILABLE_PLAYER_SESSIONS =>
      val r = AvailablePlayerSessions
      r
    case software.amazon.awssdk.services.gamelift.model.MetricName.CURRENT_PLAYER_SESSIONS =>
      val r = CurrentPlayerSessions
      r
    case software.amazon.awssdk.services.gamelift.model.MetricName.IDLE_INSTANCES =>
      val r = IdleInstances
      r
    case software.amazon.awssdk.services.gamelift.model.MetricName.PERCENT_AVAILABLE_GAME_SESSIONS =>
      val r = PercentAvailableGameSessions
      r
    case software.amazon.awssdk.services.gamelift.model.MetricName.PERCENT_IDLE_INSTANCES =>
      val r = PercentIdleInstances
      r
    case software.amazon.awssdk.services.gamelift.model.MetricName.QUEUE_DEPTH =>
      val r = QueueDepth
      r
    case software.amazon.awssdk.services.gamelift.model.MetricName.WAIT_TIME =>
      val r = WaitTime
      r
    case software.amazon.awssdk.services.gamelift.model.MetricName.CONCURRENT_ACTIVATABLE_GAME_SESSIONS =>
      val r = ConcurrentActivatableGameSessions
      r
  }
  case object unknownToSdkVersion extends zio.aws.gamelift.model.MetricName {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.MetricName =
      software.amazon.awssdk.services.gamelift.model.MetricName.UNKNOWN_TO_SDK_VERSION
  }
  case object ActivatingGameSessions extends zio.aws.gamelift.model.MetricName {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.MetricName =
      software.amazon.awssdk.services.gamelift.model.MetricName.ACTIVATING_GAME_SESSIONS
  }
  case object ActiveGameSessions extends zio.aws.gamelift.model.MetricName {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.MetricName =
      software.amazon.awssdk.services.gamelift.model.MetricName.ACTIVE_GAME_SESSIONS
  }
  case object ActiveInstances extends zio.aws.gamelift.model.MetricName {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.MetricName =
      software.amazon.awssdk.services.gamelift.model.MetricName.ACTIVE_INSTANCES
  }
  case object AvailableGameSessions extends zio.aws.gamelift.model.MetricName {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.MetricName =
      software.amazon.awssdk.services.gamelift.model.MetricName.AVAILABLE_GAME_SESSIONS
  }
  case object AvailablePlayerSessions
      extends zio.aws.gamelift.model.MetricName {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.MetricName =
      software.amazon.awssdk.services.gamelift.model.MetricName.AVAILABLE_PLAYER_SESSIONS
  }
  case object CurrentPlayerSessions extends zio.aws.gamelift.model.MetricName {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.MetricName =
      software.amazon.awssdk.services.gamelift.model.MetricName.CURRENT_PLAYER_SESSIONS
  }
  case object IdleInstances extends zio.aws.gamelift.model.MetricName {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.MetricName =
      software.amazon.awssdk.services.gamelift.model.MetricName.IDLE_INSTANCES
  }
  case object PercentAvailableGameSessions
      extends zio.aws.gamelift.model.MetricName {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.MetricName =
      software.amazon.awssdk.services.gamelift.model.MetricName.PERCENT_AVAILABLE_GAME_SESSIONS
  }
  case object PercentIdleInstances extends zio.aws.gamelift.model.MetricName {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.MetricName =
      software.amazon.awssdk.services.gamelift.model.MetricName.PERCENT_IDLE_INSTANCES
  }
  case object QueueDepth extends zio.aws.gamelift.model.MetricName {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.MetricName =
      software.amazon.awssdk.services.gamelift.model.MetricName.QUEUE_DEPTH
  }
  case object WaitTime extends zio.aws.gamelift.model.MetricName {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.MetricName =
      software.amazon.awssdk.services.gamelift.model.MetricName.WAIT_TIME
  }
  case object ConcurrentActivatableGameSessions
      extends zio.aws.gamelift.model.MetricName {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.MetricName =
      software.amazon.awssdk.services.gamelift.model.MetricName.CONCURRENT_ACTIVATABLE_GAME_SESSIONS
  }
}
