package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RegisterComputeResponse(
    compute: Optional[zio.aws.gamelift.model.Compute] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.RegisterComputeResponse = {
    import RegisterComputeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.RegisterComputeResponse
      .builder()
      .optionallyWith(compute.map(value => value.buildAwsValue()))(_.compute)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.RegisterComputeResponse.ReadOnly =
    zio.aws.gamelift.model.RegisterComputeResponse.wrap(buildAwsValue())
}
object RegisterComputeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.RegisterComputeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.RegisterComputeResponse =
      zio.aws.gamelift.model
        .RegisterComputeResponse(compute.map(value => value.asEditable))
    def compute: Optional[zio.aws.gamelift.model.Compute.ReadOnly]
    def getCompute
        : ZIO[Any, AwsError, zio.aws.gamelift.model.Compute.ReadOnly] =
      AwsError.unwrapOptionField("compute", compute)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.RegisterComputeResponse
  ) extends zio.aws.gamelift.model.RegisterComputeResponse.ReadOnly {
    override val compute: Optional[zio.aws.gamelift.model.Compute.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compute())
        .map(value => zio.aws.gamelift.model.Compute.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.RegisterComputeResponse
  ): zio.aws.gamelift.model.RegisterComputeResponse.ReadOnly = new Wrapper(impl)
}
