package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.AliasIdOrArn
import scala.jdk.CollectionConverters._
final case class ResolveAliasRequest(aliasId: AliasIdOrArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.ResolveAliasRequest = {
    import ResolveAliasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.ResolveAliasRequest
      .builder()
      .aliasId(AliasIdOrArn.unwrap(aliasId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.ResolveAliasRequest.ReadOnly =
    zio.aws.gamelift.model.ResolveAliasRequest.wrap(buildAwsValue())
}
object ResolveAliasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.ResolveAliasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.ResolveAliasRequest =
      zio.aws.gamelift.model.ResolveAliasRequest(aliasId)
    def aliasId: AliasIdOrArn
    def getAliasId: ZIO[Any, Nothing, AliasIdOrArn] = ZIO.succeed(aliasId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.ResolveAliasRequest
  ) extends zio.aws.gamelift.model.ResolveAliasRequest.ReadOnly {
    override val aliasId: AliasIdOrArn =
      zio.aws.gamelift.model.primitives.AliasIdOrArn(impl.aliasId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.ResolveAliasRequest
  ): zio.aws.gamelift.model.ResolveAliasRequest.ReadOnly = new Wrapper(impl)
}
