package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.WholeNumber
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ResourceCreationLimitPolicy(
    newGameSessionsPerCreator: Optional[WholeNumber] = Optional.Absent,
    policyPeriodInMinutes: Optional[WholeNumber] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.ResourceCreationLimitPolicy = {
    import ResourceCreationLimitPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.ResourceCreationLimitPolicy
      .builder()
      .optionallyWith(
        newGameSessionsPerCreator.map(value =>
          WholeNumber.unwrap(value): Integer
        )
      )(_.newGameSessionsPerCreator)
      .optionallyWith(
        policyPeriodInMinutes.map(value => WholeNumber.unwrap(value): Integer)
      )(_.policyPeriodInMinutes)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.ResourceCreationLimitPolicy.ReadOnly =
    zio.aws.gamelift.model.ResourceCreationLimitPolicy.wrap(buildAwsValue())
}
object ResourceCreationLimitPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.ResourceCreationLimitPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.ResourceCreationLimitPolicy =
      zio.aws.gamelift.model.ResourceCreationLimitPolicy(
        newGameSessionsPerCreator.map(value => value),
        policyPeriodInMinutes.map(value => value)
      )
    def newGameSessionsPerCreator: Optional[WholeNumber]
    def policyPeriodInMinutes: Optional[WholeNumber]
    def getNewGameSessionsPerCreator: ZIO[Any, AwsError, WholeNumber] = AwsError
      .unwrapOptionField("newGameSessionsPerCreator", newGameSessionsPerCreator)
    def getPolicyPeriodInMinutes: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("policyPeriodInMinutes", policyPeriodInMinutes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.ResourceCreationLimitPolicy
  ) extends zio.aws.gamelift.model.ResourceCreationLimitPolicy.ReadOnly {
    override val newGameSessionsPerCreator: Optional[WholeNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.newGameSessionsPerCreator())
        .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
    override val policyPeriodInMinutes: Optional[WholeNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyPeriodInMinutes())
        .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.ResourceCreationLimitPolicy
  ): zio.aws.gamelift.model.ResourceCreationLimitPolicy.ReadOnly = new Wrapper(
    impl
  )
}
