package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.GameServerGroupNameOrArn
import scala.jdk.CollectionConverters._
final case class ResumeGameServerGroupRequest(
    gameServerGroupName: GameServerGroupNameOrArn,
    resumeActions: Iterable[zio.aws.gamelift.model.GameServerGroupAction]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.ResumeGameServerGroupRequest = {
    import ResumeGameServerGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.ResumeGameServerGroupRequest
      .builder()
      .gameServerGroupName(
        GameServerGroupNameOrArn.unwrap(gameServerGroupName): java.lang.String
      )
      .resumeActionsWithStrings(resumeActions.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.ResumeGameServerGroupRequest.ReadOnly =
    zio.aws.gamelift.model.ResumeGameServerGroupRequest.wrap(buildAwsValue())
}
object ResumeGameServerGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.ResumeGameServerGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.ResumeGameServerGroupRequest =
      zio.aws.gamelift.model
        .ResumeGameServerGroupRequest(gameServerGroupName, resumeActions)
    def gameServerGroupName: GameServerGroupNameOrArn
    def resumeActions: List[zio.aws.gamelift.model.GameServerGroupAction]
    def getGameServerGroupName: ZIO[Any, Nothing, GameServerGroupNameOrArn] =
      ZIO.succeed(gameServerGroupName)
    def getResumeActions: ZIO[Any, Nothing, List[
      zio.aws.gamelift.model.GameServerGroupAction
    ]] = ZIO.succeed(resumeActions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.ResumeGameServerGroupRequest
  ) extends zio.aws.gamelift.model.ResumeGameServerGroupRequest.ReadOnly {
    override val gameServerGroupName: GameServerGroupNameOrArn =
      zio.aws.gamelift.model.primitives
        .GameServerGroupNameOrArn(impl.gameServerGroupName())
    override val resumeActions
        : List[zio.aws.gamelift.model.GameServerGroupAction] = impl
      .resumeActions()
      .asScala
      .map { item =>
        zio.aws.gamelift.model.GameServerGroupAction.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.ResumeGameServerGroupRequest
  ): zio.aws.gamelift.model.ResumeGameServerGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
