package zio.aws.gamelift.model
import scala.jdk.CollectionConverters._
sealed trait ScalingAdjustmentType {
  def unwrap
      : software.amazon.awssdk.services.gamelift.model.ScalingAdjustmentType
}
object ScalingAdjustmentType {
  def wrap(
      value: software.amazon.awssdk.services.gamelift.model.ScalingAdjustmentType
  ): zio.aws.gamelift.model.ScalingAdjustmentType = value match {
    case software.amazon.awssdk.services.gamelift.model.ScalingAdjustmentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.gamelift.model.ScalingAdjustmentType.CHANGE_IN_CAPACITY =>
      val r = ChangeInCapacity
      r
    case software.amazon.awssdk.services.gamelift.model.ScalingAdjustmentType.EXACT_CAPACITY =>
      val r = ExactCapacity
      r
    case software.amazon.awssdk.services.gamelift.model.ScalingAdjustmentType.PERCENT_CHANGE_IN_CAPACITY =>
      val r = PercentChangeInCapacity
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.gamelift.model.ScalingAdjustmentType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.ScalingAdjustmentType =
      software.amazon.awssdk.services.gamelift.model.ScalingAdjustmentType.UNKNOWN_TO_SDK_VERSION
  }
  case object ChangeInCapacity
      extends zio.aws.gamelift.model.ScalingAdjustmentType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.ScalingAdjustmentType =
      software.amazon.awssdk.services.gamelift.model.ScalingAdjustmentType.CHANGE_IN_CAPACITY
  }
  case object ExactCapacity
      extends zio.aws.gamelift.model.ScalingAdjustmentType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.ScalingAdjustmentType =
      software.amazon.awssdk.services.gamelift.model.ScalingAdjustmentType.EXACT_CAPACITY
  }
  case object PercentChangeInCapacity
      extends zio.aws.gamelift.model.ScalingAdjustmentType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.ScalingAdjustmentType =
      software.amazon.awssdk.services.gamelift.model.ScalingAdjustmentType.PERCENT_CHANGE_IN_CAPACITY
  }
}
