package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.{FleetArn, FleetId}
import scala.jdk.CollectionConverters._
final case class StartFleetActionsResponse(
    fleetId: Optional[FleetId] = Optional.Absent,
    fleetArn: Optional[FleetArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.StartFleetActionsResponse = {
    import StartFleetActionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.StartFleetActionsResponse
      .builder()
      .optionallyWith(
        fleetId.map(value => FleetId.unwrap(value): java.lang.String)
      )(_.fleetId)
      .optionallyWith(
        fleetArn.map(value => FleetArn.unwrap(value): java.lang.String)
      )(_.fleetArn)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.StartFleetActionsResponse.ReadOnly =
    zio.aws.gamelift.model.StartFleetActionsResponse.wrap(buildAwsValue())
}
object StartFleetActionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.StartFleetActionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.StartFleetActionsResponse =
      zio.aws.gamelift.model.StartFleetActionsResponse(
        fleetId.map(value => value),
        fleetArn.map(value => value)
      )
    def fleetId: Optional[FleetId]
    def fleetArn: Optional[FleetArn]
    def getFleetId: ZIO[Any, AwsError, FleetId] =
      AwsError.unwrapOptionField("fleetId", fleetId)
    def getFleetArn: ZIO[Any, AwsError, FleetArn] =
      AwsError.unwrapOptionField("fleetArn", fleetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.StartFleetActionsResponse
  ) extends zio.aws.gamelift.model.StartFleetActionsResponse.ReadOnly {
    override val fleetId: Optional[FleetId] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetId())
      .map(value => zio.aws.gamelift.model.primitives.FleetId(value))
    override val fleetArn: Optional[FleetArn] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetArn())
      .map(value => zio.aws.gamelift.model.primitives.FleetArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.StartFleetActionsResponse
  ): zio.aws.gamelift.model.StartFleetActionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
