package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartGameSessionPlacementResponse(
    gameSessionPlacement: Optional[
      zio.aws.gamelift.model.GameSessionPlacement
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.StartGameSessionPlacementResponse = {
    import StartGameSessionPlacementResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.StartGameSessionPlacementResponse
      .builder()
      .optionallyWith(gameSessionPlacement.map(value => value.buildAwsValue()))(
        _.gameSessionPlacement
      )
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.StartGameSessionPlacementResponse.ReadOnly =
    zio.aws.gamelift.model.StartGameSessionPlacementResponse
      .wrap(buildAwsValue())
}
object StartGameSessionPlacementResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.StartGameSessionPlacementResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.StartGameSessionPlacementResponse =
      zio.aws.gamelift.model.StartGameSessionPlacementResponse(
        gameSessionPlacement.map(value => value.asEditable)
      )
    def gameSessionPlacement
        : Optional[zio.aws.gamelift.model.GameSessionPlacement.ReadOnly]
    def getGameSessionPlacement: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.GameSessionPlacement.ReadOnly
    ] = AwsError.unwrapOptionField("gameSessionPlacement", gameSessionPlacement)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.StartGameSessionPlacementResponse
  ) extends zio.aws.gamelift.model.StartGameSessionPlacementResponse.ReadOnly {
    override val gameSessionPlacement
        : Optional[zio.aws.gamelift.model.GameSessionPlacement.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameSessionPlacement())
        .map(value => zio.aws.gamelift.model.GameSessionPlacement.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.StartGameSessionPlacementResponse
  ): zio.aws.gamelift.model.StartGameSessionPlacementResponse.ReadOnly =
    new Wrapper(impl)
}
