package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.GameServerGroupNameOrArn
import scala.jdk.CollectionConverters._
final case class SuspendGameServerGroupRequest(
    gameServerGroupName: GameServerGroupNameOrArn,
    suspendActions: Iterable[zio.aws.gamelift.model.GameServerGroupAction]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.SuspendGameServerGroupRequest = {
    import SuspendGameServerGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.SuspendGameServerGroupRequest
      .builder()
      .gameServerGroupName(
        GameServerGroupNameOrArn.unwrap(gameServerGroupName): java.lang.String
      )
      .suspendActionsWithStrings(suspendActions.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.SuspendGameServerGroupRequest.ReadOnly =
    zio.aws.gamelift.model.SuspendGameServerGroupRequest.wrap(buildAwsValue())
}
object SuspendGameServerGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.SuspendGameServerGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.SuspendGameServerGroupRequest =
      zio.aws.gamelift.model
        .SuspendGameServerGroupRequest(gameServerGroupName, suspendActions)
    def gameServerGroupName: GameServerGroupNameOrArn
    def suspendActions: List[zio.aws.gamelift.model.GameServerGroupAction]
    def getGameServerGroupName: ZIO[Any, Nothing, GameServerGroupNameOrArn] =
      ZIO.succeed(gameServerGroupName)
    def getSuspendActions: ZIO[Any, Nothing, List[
      zio.aws.gamelift.model.GameServerGroupAction
    ]] = ZIO.succeed(suspendActions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.SuspendGameServerGroupRequest
  ) extends zio.aws.gamelift.model.SuspendGameServerGroupRequest.ReadOnly {
    override val gameServerGroupName: GameServerGroupNameOrArn =
      zio.aws.gamelift.model.primitives
        .GameServerGroupNameOrArn(impl.gameServerGroupName())
    override val suspendActions
        : List[zio.aws.gamelift.model.GameServerGroupAction] = impl
      .suspendActions()
      .asScala
      .map { item =>
        zio.aws.gamelift.model.GameServerGroupAction.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.SuspendGameServerGroupRequest
  ): zio.aws.gamelift.model.SuspendGameServerGroupRequest.ReadOnly =
    new Wrapper(impl)
}
