package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.NonNegativeDouble
import scala.jdk.CollectionConverters._
final case class TargetTrackingConfiguration(targetValue: NonNegativeDouble) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.TargetTrackingConfiguration = {
    import TargetTrackingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.TargetTrackingConfiguration
      .builder()
      .targetValue(NonNegativeDouble.unwrap(targetValue): java.lang.Double)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.TargetTrackingConfiguration.ReadOnly =
    zio.aws.gamelift.model.TargetTrackingConfiguration.wrap(buildAwsValue())
}
object TargetTrackingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.TargetTrackingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.TargetTrackingConfiguration =
      zio.aws.gamelift.model.TargetTrackingConfiguration(targetValue)
    def targetValue: NonNegativeDouble
    def getTargetValue: ZIO[Any, Nothing, NonNegativeDouble] =
      ZIO.succeed(targetValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.TargetTrackingConfiguration
  ) extends zio.aws.gamelift.model.TargetTrackingConfiguration.ReadOnly {
    override val targetValue: NonNegativeDouble =
      zio.aws.gamelift.model.primitives.NonNegativeDouble(impl.targetValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.TargetTrackingConfiguration
  ): zio.aws.gamelift.model.TargetTrackingConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
