package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateAliasResponse(
    alias: Optional[zio.aws.gamelift.model.Alias] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.UpdateAliasResponse = {
    import UpdateAliasResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.UpdateAliasResponse
      .builder()
      .optionallyWith(alias.map(value => value.buildAwsValue()))(_.alias)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.UpdateAliasResponse.ReadOnly =
    zio.aws.gamelift.model.UpdateAliasResponse.wrap(buildAwsValue())
}
object UpdateAliasResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.UpdateAliasResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.UpdateAliasResponse =
      zio.aws.gamelift.model
        .UpdateAliasResponse(alias.map(value => value.asEditable))
    def alias: Optional[zio.aws.gamelift.model.Alias.ReadOnly]
    def getAlias: ZIO[Any, AwsError, zio.aws.gamelift.model.Alias.ReadOnly] =
      AwsError.unwrapOptionField("alias", alias)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateAliasResponse
  ) extends zio.aws.gamelift.model.UpdateAliasResponse.ReadOnly {
    override val alias: Optional[zio.aws.gamelift.model.Alias.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alias())
        .map(value => zio.aws.gamelift.model.Alias.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateAliasResponse
  ): zio.aws.gamelift.model.UpdateAliasResponse.ReadOnly = new Wrapper(impl)
}
