package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateBuildResponse(
    build: Optional[zio.aws.gamelift.model.Build] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.UpdateBuildResponse = {
    import UpdateBuildResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.UpdateBuildResponse
      .builder()
      .optionallyWith(build.map(value => value.buildAwsValue()))(_.build)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.UpdateBuildResponse.ReadOnly =
    zio.aws.gamelift.model.UpdateBuildResponse.wrap(buildAwsValue())
}
object UpdateBuildResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.UpdateBuildResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.UpdateBuildResponse =
      zio.aws.gamelift.model
        .UpdateBuildResponse(build.map(value => value.asEditable))
    def build: Optional[zio.aws.gamelift.model.Build.ReadOnly]
    def getBuild: ZIO[Any, AwsError, zio.aws.gamelift.model.Build.ReadOnly] =
      AwsError.unwrapOptionField("build", build)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateBuildResponse
  ) extends zio.aws.gamelift.model.UpdateBuildResponse.ReadOnly {
    override val build: Optional[zio.aws.gamelift.model.Build.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.build())
        .map(value => zio.aws.gamelift.model.Build.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateBuildResponse
  ): zio.aws.gamelift.model.UpdateBuildResponse.ReadOnly = new Wrapper(impl)
}
