package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.{
  MetricGroup,
  NonZeroAndMaxString,
  FleetIdOrArn
}
import scala.jdk.CollectionConverters._
final case class UpdateFleetAttributesRequest(
    fleetId: FleetIdOrArn,
    name: Optional[NonZeroAndMaxString] = Optional.Absent,
    description: Optional[NonZeroAndMaxString] = Optional.Absent,
    newGameSessionProtectionPolicy: Optional[
      zio.aws.gamelift.model.ProtectionPolicy
    ] = Optional.Absent,
    resourceCreationLimitPolicy: Optional[
      zio.aws.gamelift.model.ResourceCreationLimitPolicy
    ] = Optional.Absent,
    metricGroups: Optional[Iterable[MetricGroup]] = Optional.Absent,
    anywhereConfiguration: Optional[
      zio.aws.gamelift.model.AnywhereConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.UpdateFleetAttributesRequest = {
    import UpdateFleetAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.UpdateFleetAttributesRequest
      .builder()
      .fleetId(FleetIdOrArn.unwrap(fleetId): java.lang.String)
      .optionallyWith(
        name.map(value => NonZeroAndMaxString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        newGameSessionProtectionPolicy.map(value => value.unwrap)
      )(_.newGameSessionProtectionPolicy)
      .optionallyWith(
        resourceCreationLimitPolicy.map(value => value.buildAwsValue())
      )(_.resourceCreationLimitPolicy)
      .optionallyWith(
        metricGroups.map(value =>
          value.map { item =>
            MetricGroup.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.metricGroups)
      .optionallyWith(
        anywhereConfiguration.map(value => value.buildAwsValue())
      )(_.anywhereConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.UpdateFleetAttributesRequest.ReadOnly =
    zio.aws.gamelift.model.UpdateFleetAttributesRequest.wrap(buildAwsValue())
}
object UpdateFleetAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.UpdateFleetAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.UpdateFleetAttributesRequest =
      zio.aws.gamelift.model.UpdateFleetAttributesRequest(
        fleetId,
        name.map(value => value),
        description.map(value => value),
        newGameSessionProtectionPolicy.map(value => value),
        resourceCreationLimitPolicy.map(value => value.asEditable),
        metricGroups.map(value => value),
        anywhereConfiguration.map(value => value.asEditable)
      )
    def fleetId: FleetIdOrArn
    def name: Optional[NonZeroAndMaxString]
    def description: Optional[NonZeroAndMaxString]
    def newGameSessionProtectionPolicy
        : Optional[zio.aws.gamelift.model.ProtectionPolicy]
    def resourceCreationLimitPolicy
        : Optional[zio.aws.gamelift.model.ResourceCreationLimitPolicy.ReadOnly]
    def metricGroups: Optional[List[MetricGroup]]
    def anywhereConfiguration
        : Optional[zio.aws.gamelift.model.AnywhereConfiguration.ReadOnly]
    def getFleetId: ZIO[Any, Nothing, FleetIdOrArn] = ZIO.succeed(fleetId)
    def getName: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("description", description)
    def getNewGameSessionProtectionPolicy
        : ZIO[Any, AwsError, zio.aws.gamelift.model.ProtectionPolicy] =
      AwsError.unwrapOptionField(
        "newGameSessionProtectionPolicy",
        newGameSessionProtectionPolicy
      )
    def getResourceCreationLimitPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.ResourceCreationLimitPolicy.ReadOnly
    ] = AwsError.unwrapOptionField(
      "resourceCreationLimitPolicy",
      resourceCreationLimitPolicy
    )
    def getMetricGroups: ZIO[Any, AwsError, List[MetricGroup]] =
      AwsError.unwrapOptionField("metricGroups", metricGroups)
    def getAnywhereConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.AnywhereConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("anywhereConfiguration", anywhereConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateFleetAttributesRequest
  ) extends zio.aws.gamelift.model.UpdateFleetAttributesRequest.ReadOnly {
    override val fleetId: FleetIdOrArn =
      zio.aws.gamelift.model.primitives.FleetIdOrArn(impl.fleetId())
    override val name: Optional[NonZeroAndMaxString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val description: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
    override val newGameSessionProtectionPolicy
        : Optional[zio.aws.gamelift.model.ProtectionPolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.newGameSessionProtectionPolicy())
        .map(value => zio.aws.gamelift.model.ProtectionPolicy.wrap(value))
    override val resourceCreationLimitPolicy: Optional[
      zio.aws.gamelift.model.ResourceCreationLimitPolicy.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceCreationLimitPolicy())
      .map(value =>
        zio.aws.gamelift.model.ResourceCreationLimitPolicy.wrap(value)
      )
    override val metricGroups: Optional[List[MetricGroup]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.primitives.MetricGroup(item)
          }.toList
        )
    override val anywhereConfiguration
        : Optional[zio.aws.gamelift.model.AnywhereConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.anywhereConfiguration())
        .map(value => zio.aws.gamelift.model.AnywhereConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateFleetAttributesRequest
  ): zio.aws.gamelift.model.UpdateFleetAttributesRequest.ReadOnly = new Wrapper(
    impl
  )
}
