package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.{
  LocationStringModel,
  FleetArn,
  FleetId
}
import scala.jdk.CollectionConverters._
final case class UpdateFleetCapacityResponse(
    fleetId: Optional[FleetId] = Optional.Absent,
    fleetArn: Optional[FleetArn] = Optional.Absent,
    location: Optional[LocationStringModel] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.UpdateFleetCapacityResponse = {
    import UpdateFleetCapacityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.UpdateFleetCapacityResponse
      .builder()
      .optionallyWith(
        fleetId.map(value => FleetId.unwrap(value): java.lang.String)
      )(_.fleetId)
      .optionallyWith(
        fleetArn.map(value => FleetArn.unwrap(value): java.lang.String)
      )(_.fleetArn)
      .optionallyWith(
        location.map(value =>
          LocationStringModel.unwrap(value): java.lang.String
        )
      )(_.location)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.UpdateFleetCapacityResponse.ReadOnly =
    zio.aws.gamelift.model.UpdateFleetCapacityResponse.wrap(buildAwsValue())
}
object UpdateFleetCapacityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.UpdateFleetCapacityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.UpdateFleetCapacityResponse =
      zio.aws.gamelift.model.UpdateFleetCapacityResponse(
        fleetId.map(value => value),
        fleetArn.map(value => value),
        location.map(value => value)
      )
    def fleetId: Optional[FleetId]
    def fleetArn: Optional[FleetArn]
    def location: Optional[LocationStringModel]
    def getFleetId: ZIO[Any, AwsError, FleetId] =
      AwsError.unwrapOptionField("fleetId", fleetId)
    def getFleetArn: ZIO[Any, AwsError, FleetArn] =
      AwsError.unwrapOptionField("fleetArn", fleetArn)
    def getLocation: ZIO[Any, AwsError, LocationStringModel] =
      AwsError.unwrapOptionField("location", location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateFleetCapacityResponse
  ) extends zio.aws.gamelift.model.UpdateFleetCapacityResponse.ReadOnly {
    override val fleetId: Optional[FleetId] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetId())
      .map(value => zio.aws.gamelift.model.primitives.FleetId(value))
    override val fleetArn: Optional[FleetArn] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetArn())
      .map(value => zio.aws.gamelift.model.primitives.FleetArn(value))
    override val location: Optional[LocationStringModel] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value =>
        zio.aws.gamelift.model.primitives.LocationStringModel(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateFleetCapacityResponse
  ): zio.aws.gamelift.model.UpdateFleetCapacityResponse.ReadOnly = new Wrapper(
    impl
  )
}
