package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.{IamRoleArn, GameServerGroupNameOrArn}
import scala.jdk.CollectionConverters._
final case class UpdateGameServerGroupRequest(
    gameServerGroupName: GameServerGroupNameOrArn,
    roleArn: Optional[IamRoleArn] = Optional.Absent,
    instanceDefinitions: Optional[
      Iterable[zio.aws.gamelift.model.InstanceDefinition]
    ] = Optional.Absent,
    gameServerProtectionPolicy: Optional[
      zio.aws.gamelift.model.GameServerProtectionPolicy
    ] = Optional.Absent,
    balancingStrategy: Optional[zio.aws.gamelift.model.BalancingStrategy] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.UpdateGameServerGroupRequest = {
    import UpdateGameServerGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.UpdateGameServerGroupRequest
      .builder()
      .gameServerGroupName(
        GameServerGroupNameOrArn.unwrap(gameServerGroupName): java.lang.String
      )
      .optionallyWith(
        roleArn.map(value => IamRoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        instanceDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceDefinitions)
      .optionallyWith(gameServerProtectionPolicy.map(value => value.unwrap))(
        _.gameServerProtectionPolicy
      )
      .optionallyWith(balancingStrategy.map(value => value.unwrap))(
        _.balancingStrategy
      )
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.UpdateGameServerGroupRequest.ReadOnly =
    zio.aws.gamelift.model.UpdateGameServerGroupRequest.wrap(buildAwsValue())
}
object UpdateGameServerGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.UpdateGameServerGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.UpdateGameServerGroupRequest =
      zio.aws.gamelift.model.UpdateGameServerGroupRequest(
        gameServerGroupName,
        roleArn.map(value => value),
        instanceDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        gameServerProtectionPolicy.map(value => value),
        balancingStrategy.map(value => value)
      )
    def gameServerGroupName: GameServerGroupNameOrArn
    def roleArn: Optional[IamRoleArn]
    def instanceDefinitions
        : Optional[List[zio.aws.gamelift.model.InstanceDefinition.ReadOnly]]
    def gameServerProtectionPolicy
        : Optional[zio.aws.gamelift.model.GameServerProtectionPolicy]
    def balancingStrategy: Optional[zio.aws.gamelift.model.BalancingStrategy]
    def getGameServerGroupName: ZIO[Any, Nothing, GameServerGroupNameOrArn] =
      ZIO.succeed(gameServerGroupName)
    def getRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getInstanceDefinitions: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.InstanceDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField("instanceDefinitions", instanceDefinitions)
    def getGameServerProtectionPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.GameServerProtectionPolicy
    ] = AwsError.unwrapOptionField(
      "gameServerProtectionPolicy",
      gameServerProtectionPolicy
    )
    def getBalancingStrategy
        : ZIO[Any, AwsError, zio.aws.gamelift.model.BalancingStrategy] =
      AwsError.unwrapOptionField("balancingStrategy", balancingStrategy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateGameServerGroupRequest
  ) extends zio.aws.gamelift.model.UpdateGameServerGroupRequest.ReadOnly {
    override val gameServerGroupName: GameServerGroupNameOrArn =
      zio.aws.gamelift.model.primitives
        .GameServerGroupNameOrArn(impl.gameServerGroupName())
    override val roleArn: Optional[IamRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.gamelift.model.primitives.IamRoleArn(value))
    override val instanceDefinitions
        : Optional[List[zio.aws.gamelift.model.InstanceDefinition.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceDefinitions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.InstanceDefinition.wrap(item)
          }.toList
        )
    override val gameServerProtectionPolicy
        : Optional[zio.aws.gamelift.model.GameServerProtectionPolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameServerProtectionPolicy())
        .map(value =>
          zio.aws.gamelift.model.GameServerProtectionPolicy.wrap(value)
        )
    override val balancingStrategy
        : Optional[zio.aws.gamelift.model.BalancingStrategy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.balancingStrategy())
        .map(value => zio.aws.gamelift.model.BalancingStrategy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateGameServerGroupRequest
  ): zio.aws.gamelift.model.UpdateGameServerGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
