package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.BooleanModel
import scala.jdk.CollectionConverters._
final case class ValidateMatchmakingRuleSetResponse(
    valid: Optional[BooleanModel] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.ValidateMatchmakingRuleSetResponse = {
    import ValidateMatchmakingRuleSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.ValidateMatchmakingRuleSetResponse
      .builder()
      .optionallyWith(
        valid.map(value => BooleanModel.unwrap(value): java.lang.Boolean)
      )(_.valid)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.ValidateMatchmakingRuleSetResponse.ReadOnly =
    zio.aws.gamelift.model.ValidateMatchmakingRuleSetResponse
      .wrap(buildAwsValue())
}
object ValidateMatchmakingRuleSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.ValidateMatchmakingRuleSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.ValidateMatchmakingRuleSetResponse =
      zio.aws.gamelift.model
        .ValidateMatchmakingRuleSetResponse(valid.map(value => value))
    def valid: Optional[BooleanModel]
    def getValid: ZIO[Any, AwsError, BooleanModel] =
      AwsError.unwrapOptionField("valid", valid)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.ValidateMatchmakingRuleSetResponse
  ) extends zio.aws.gamelift.model.ValidateMatchmakingRuleSetResponse.ReadOnly {
    override val valid: Optional[BooleanModel] = zio.aws.core.internal
      .optionalFromNullable(impl.valid())
      .map(value => zio.aws.gamelift.model.primitives.BooleanModel(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.ValidateMatchmakingRuleSetResponse
  ): zio.aws.gamelift.model.ValidateMatchmakingRuleSetResponse.ReadOnly =
    new Wrapper(impl)
}
