package zio.aws.gamelift
import zio.aws.gamelift.model.MatchmakingConfiguration.ReadOnly
import zio.aws.gamelift.model.{
  DeleteGameSessionQueueRequest,
  ListGameServersRequest,
  ClaimGameServerRequest,
  ListFleetsRequest,
  DescribeVpcPeeringAuthorizationsRequest,
  DescribeGameSessionPlacementRequest,
  ListScriptsRequest,
  CreateScriptRequest,
  DescribeMatchmakingRuleSetsRequest,
  DescribeFleetLocationAttributesRequest,
  AcceptMatchRequest,
  ValidateMatchmakingRuleSetRequest,
  DescribeGameSessionDetailsRequest,
  UpdateFleetCapacityRequest,
  UpdateAliasRequest,
  ResumeGameServerGroupRequest,
  UpdateGameSessionRequest,
  DeleteGameServerGroupRequest,
  CreateGameServerGroupRequest,
  DescribeBuildRequest,
  DescribeFleetEventsRequest,
  DescribeFleetPortSettingsRequest,
  StopGameSessionPlacementRequest,
  RegisterGameServerRequest,
  UpdateGameSessionQueueRequest,
  DescribeGameServerRequest,
  DescribeGameServerInstancesRequest,
  SuspendGameServerGroupRequest,
  UpdateGameServerRequest,
  CreateAliasRequest,
  DeleteBuildRequest,
  DeleteMatchmakingConfigurationRequest,
  DescribeGameSessionsRequest,
  DescribeMatchmakingRequest,
  ListTagsForResourceRequest,
  UpdateRuntimeConfigurationRequest,
  RequestUploadCredentialsRequest,
  DeleteAliasRequest,
  ListAliasesRequest,
  CreateGameSessionRequest,
  CreateMatchmakingConfigurationRequest,
  ListBuildsRequest,
  GetGameSessionLogUrlRequest,
  UpdateGameServerGroupRequest,
  ListGameServerGroupsRequest,
  DeleteScalingPolicyRequest,
  UpdateFleetAttributesRequest,
  PutScalingPolicyRequest,
  UpdateBuildRequest,
  DescribeFleetAttributesRequest,
  DeregisterGameServerRequest,
  ResolveAliasRequest,
  DeleteVpcPeeringAuthorizationRequest,
  DescribePlayerSessionsRequest,
  DescribeVpcPeeringConnectionsRequest,
  DescribeFleetCapacityRequest,
  CreatePlayerSessionRequest,
  CreateVpcPeeringConnectionRequest,
  SearchGameSessionsRequest,
  StopMatchmakingRequest,
  DescribeScriptRequest,
  DescribeAliasRequest,
  CreateFleetRequest,
  StopFleetActionsRequest,
  DeleteMatchmakingRuleSetRequest,
  DescribeMatchmakingConfigurationsRequest,
  CreatePlayerSessionsRequest,
  DescribeFleetLocationCapacityRequest,
  CreateBuildRequest,
  StartGameSessionPlacementRequest,
  UntagResourceRequest,
  DescribeFleetLocationUtilizationRequest,
  DescribeGameServerGroupRequest,
  DescribeInstancesRequest,
  DescribeGameSessionQueuesRequest,
  UpdateMatchmakingConfigurationRequest,
  UpdateScriptRequest,
  CreateGameSessionQueueRequest,
  StartMatchmakingRequest,
  CreateMatchmakingRuleSetRequest,
  UpdateFleetPortSettingsRequest,
  DeleteVpcPeeringConnectionRequest,
  StartMatchBackfillRequest,
  CreateVpcPeeringAuthorizationRequest,
  StartFleetActionsRequest,
  DescribeFleetUtilizationRequest,
  TagResourceRequest,
  DescribeRuntimeConfigurationRequest,
  DeleteFleetRequest,
  DeleteScriptRequest,
  DescribeScalingPoliciesRequest,
  GetInstanceAccessRequest,
  DeleteFleetLocationsRequest,
  CreateFleetLocationsRequest,
  DescribeEc2InstanceLimitsRequest
}
import zio.aws.gamelift.model.primitives.FleetId
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.{ZIO, IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import software.amazon.awssdk.services.gamelift.GameLiftAsyncClient
import zio.test.mock.{Proxy, Mock}
object GameLiftMock extends Mock[GameLift] {
  object DeleteBuild extends Effect[DeleteBuildRequest, AwsError, Unit]
  object DescribeVpcPeeringConnections
      extends Effect[
        DescribeVpcPeeringConnectionsRequest,
        AwsError,
        zio.aws.gamelift.model.DescribeVpcPeeringConnectionsResponse.ReadOnly
      ]
  object StartMatchmaking
      extends Effect[
        StartMatchmakingRequest,
        AwsError,
        zio.aws.gamelift.model.StartMatchmakingResponse.ReadOnly
      ]
  object UpdateGameServer
      extends Effect[
        UpdateGameServerRequest,
        AwsError,
        zio.aws.gamelift.model.UpdateGameServerResponse.ReadOnly
      ]
  object UpdateFleetPortSettings
      extends Effect[
        UpdateFleetPortSettingsRequest,
        AwsError,
        zio.aws.gamelift.model.UpdateFleetPortSettingsResponse.ReadOnly
      ]
  object DescribeMatchmaking
      extends Effect[
        DescribeMatchmakingRequest,
        AwsError,
        zio.aws.gamelift.model.DescribeMatchmakingResponse.ReadOnly
      ]
  object CreateGameSessionQueue
      extends Effect[
        CreateGameSessionQueueRequest,
        AwsError,
        zio.aws.gamelift.model.CreateGameSessionQueueResponse.ReadOnly
      ]
  object UpdateRuntimeConfiguration
      extends Effect[
        UpdateRuntimeConfigurationRequest,
        AwsError,
        zio.aws.gamelift.model.UpdateRuntimeConfigurationResponse.ReadOnly
      ]
  object DeleteScript extends Effect[DeleteScriptRequest, AwsError, Unit]
  object CreatePlayerSessions
      extends Effect[
        CreatePlayerSessionsRequest,
        AwsError,
        zio.aws.gamelift.model.CreatePlayerSessionsResponse.ReadOnly
      ]
  object StopFleetActions
      extends Effect[
        StopFleetActionsRequest,
        AwsError,
        zio.aws.gamelift.model.StopFleetActionsResponse.ReadOnly
      ]
  object DescribeInstances
      extends Stream[
        DescribeInstancesRequest,
        AwsError,
        zio.aws.gamelift.model.Instance.ReadOnly
      ]
  object DescribeInstancesPaginated
      extends Effect[
        DescribeInstancesRequest,
        AwsError,
        zio.aws.gamelift.model.DescribeInstancesResponse.ReadOnly
      ]
  object SuspendGameServerGroup
      extends Effect[
        SuspendGameServerGroupRequest,
        AwsError,
        zio.aws.gamelift.model.SuspendGameServerGroupResponse.ReadOnly
      ]
  object DescribeGameSessionDetails
      extends Stream[
        DescribeGameSessionDetailsRequest,
        AwsError,
        zio.aws.gamelift.model.GameSessionDetail.ReadOnly
      ]
  object DescribeGameSessionDetailsPaginated
      extends Effect[
        DescribeGameSessionDetailsRequest,
        AwsError,
        zio.aws.gamelift.model.DescribeGameSessionDetailsResponse.ReadOnly
      ]
  object CreateGameServerGroup
      extends Effect[
        CreateGameServerGroupRequest,
        AwsError,
        zio.aws.gamelift.model.CreateGameServerGroupResponse.ReadOnly
      ]
  object CreateScript
      extends Effect[
        CreateScriptRequest,
        AwsError,
        zio.aws.gamelift.model.CreateScriptResponse.ReadOnly
      ]
  object SearchGameSessions
      extends Stream[
        SearchGameSessionsRequest,
        AwsError,
        zio.aws.gamelift.model.GameSession.ReadOnly
      ]
  object SearchGameSessionsPaginated
      extends Effect[
        SearchGameSessionsRequest,
        AwsError,
        zio.aws.gamelift.model.SearchGameSessionsResponse.ReadOnly
      ]
  object StartMatchBackfill
      extends Effect[
        StartMatchBackfillRequest,
        AwsError,
        zio.aws.gamelift.model.StartMatchBackfillResponse.ReadOnly
      ]
  object ListFleets extends Stream[ListFleetsRequest, AwsError, FleetId]
  object ListFleetsPaginated
      extends Effect[
        ListFleetsRequest,
        AwsError,
        zio.aws.gamelift.model.ListFleetsResponse.ReadOnly
      ]
  object DescribeFleetUtilization
      extends Stream[
        DescribeFleetUtilizationRequest,
        AwsError,
        zio.aws.gamelift.model.FleetUtilization.ReadOnly
      ]
  object DescribeFleetUtilizationPaginated
      extends Effect[
        DescribeFleetUtilizationRequest,
        AwsError,
        zio.aws.gamelift.model.DescribeFleetUtilizationResponse.ReadOnly
      ]
  object CreatePlayerSession
      extends Effect[
        CreatePlayerSessionRequest,
        AwsError,
        zio.aws.gamelift.model.CreatePlayerSessionResponse.ReadOnly
      ]
  object DescribeGameSessionPlacement
      extends Effect[
        DescribeGameSessionPlacementRequest,
        AwsError,
        zio.aws.gamelift.model.DescribeGameSessionPlacementResponse.ReadOnly
      ]
  object UpdateGameSession
      extends Effect[
        UpdateGameSessionRequest,
        AwsError,
        zio.aws.gamelift.model.UpdateGameSessionResponse.ReadOnly
      ]
  object CreateVpcPeeringAuthorization
      extends Effect[
        CreateVpcPeeringAuthorizationRequest,
        AwsError,
        zio.aws.gamelift.model.CreateVpcPeeringAuthorizationResponse.ReadOnly
      ]
  object DescribeFleetLocationCapacity
      extends Effect[
        DescribeFleetLocationCapacityRequest,
        AwsError,
        zio.aws.gamelift.model.DescribeFleetLocationCapacityResponse.ReadOnly
      ]
  object ListScripts
      extends Stream[
        ListScriptsRequest,
        AwsError,
        zio.aws.gamelift.model.Script.ReadOnly
      ]
  object ListScriptsPaginated
      extends Effect[
        ListScriptsRequest,
        AwsError,
        zio.aws.gamelift.model.ListScriptsResponse.ReadOnly
      ]
  object DescribeVpcPeeringAuthorizations
      extends Effect[
        DescribeVpcPeeringAuthorizationsRequest,
        AwsError,
        zio.aws.gamelift.model.DescribeVpcPeeringAuthorizationsResponse.ReadOnly
      ]
  object CreateBuild
      extends Effect[
        CreateBuildRequest,
        AwsError,
        zio.aws.gamelift.model.CreateBuildResponse.ReadOnly
      ]
  object DeleteFleet extends Effect[DeleteFleetRequest, AwsError, Unit]
  object DescribeMatchmakingRuleSets
      extends Stream[
        DescribeMatchmakingRuleSetsRequest,
        AwsError,
        zio.aws.gamelift.model.MatchmakingRuleSet.ReadOnly
      ]
  object DescribeMatchmakingRuleSetsPaginated
      extends Effect[
        DescribeMatchmakingRuleSetsRequest,
        AwsError,
        zio.aws.gamelift.model.DescribeMatchmakingRuleSetsResponse.ReadOnly
      ]
  object PutScalingPolicy
      extends Effect[
        PutScalingPolicyRequest,
        AwsError,
        zio.aws.gamelift.model.PutScalingPolicyResponse.ReadOnly
      ]
  object DeleteGameServerGroup
      extends Effect[
        DeleteGameServerGroupRequest,
        AwsError,
        zio.aws.gamelift.model.DeleteGameServerGroupResponse.ReadOnly
      ]
  object UpdateGameSessionQueue
      extends Effect[
        UpdateGameSessionQueueRequest,
        AwsError,
        zio.aws.gamelift.model.UpdateGameSessionQueueResponse.ReadOnly
      ]
  object StopGameSessionPlacement
      extends Effect[
        StopGameSessionPlacementRequest,
        AwsError,
        zio.aws.gamelift.model.StopGameSessionPlacementResponse.ReadOnly
      ]
  object DescribeGameServerGroup
      extends Effect[
        DescribeGameServerGroupRequest,
        AwsError,
        zio.aws.gamelift.model.DescribeGameServerGroupResponse.ReadOnly
      ]
  object DeleteVpcPeeringAuthorization
      extends Effect[
        DeleteVpcPeeringAuthorizationRequest,
        AwsError,
        zio.aws.gamelift.model.DeleteVpcPeeringAuthorizationResponse.ReadOnly
      ]
  object RegisterGameServer
      extends Effect[
        RegisterGameServerRequest,
        AwsError,
        zio.aws.gamelift.model.RegisterGameServerResponse.ReadOnly
      ]
  object DescribeFleetAttributes
      extends Stream[
        DescribeFleetAttributesRequest,
        AwsError,
        zio.aws.gamelift.model.FleetAttributes.ReadOnly
      ]
  object DescribeFleetAttributesPaginated
      extends Effect[
        DescribeFleetAttributesRequest,
        AwsError,
        zio.aws.gamelift.model.DescribeFleetAttributesResponse.ReadOnly
      ]
  object DeleteVpcPeeringConnection
      extends Effect[
        DeleteVpcPeeringConnectionRequest,
        AwsError,
        zio.aws.gamelift.model.DeleteVpcPeeringConnectionResponse.ReadOnly
      ]
  object DescribeRuntimeConfiguration
      extends Effect[
        DescribeRuntimeConfigurationRequest,
        AwsError,
        zio.aws.gamelift.model.DescribeRuntimeConfigurationResponse.ReadOnly
      ]
  object ListAliases
      extends Stream[
        ListAliasesRequest,
        AwsError,
        zio.aws.gamelift.model.Alias.ReadOnly
      ]
  object ListAliasesPaginated
      extends Effect[
        ListAliasesRequest,
        AwsError,
        zio.aws.gamelift.model.ListAliasesResponse.ReadOnly
      ]
  object GetGameSessionLogUrl
      extends Effect[
        GetGameSessionLogUrlRequest,
        AwsError,
        zio.aws.gamelift.model.GetGameSessionLogUrlResponse.ReadOnly
      ]
  object DescribeAlias
      extends Effect[
        DescribeAliasRequest,
        AwsError,
        zio.aws.gamelift.model.DescribeAliasResponse.ReadOnly
      ]
  object CreateFleet
      extends Effect[
        CreateFleetRequest,
        AwsError,
        zio.aws.gamelift.model.CreateFleetResponse.ReadOnly
      ]
  object DescribeScalingPolicies
      extends Stream[
        DescribeScalingPoliciesRequest,
        AwsError,
        zio.aws.gamelift.model.ScalingPolicy.ReadOnly
      ]
  object DescribeScalingPoliciesPaginated
      extends Effect[
        DescribeScalingPoliciesRequest,
        AwsError,
        zio.aws.gamelift.model.DescribeScalingPoliciesResponse.ReadOnly
      ]
  object UpdateAlias
      extends Effect[
        UpdateAliasRequest,
        AwsError,
        zio.aws.gamelift.model.UpdateAliasResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.gamelift.model.UntagResourceResponse.ReadOnly
      ]
  object CreateAlias
      extends Effect[
        CreateAliasRequest,
        AwsError,
        zio.aws.gamelift.model.CreateAliasResponse.ReadOnly
      ]
  object UpdateFleetAttributes
      extends Effect[
        UpdateFleetAttributesRequest,
        AwsError,
        zio.aws.gamelift.model.UpdateFleetAttributesResponse.ReadOnly
      ]
  object DescribeFleetLocationUtilization
      extends Effect[
        DescribeFleetLocationUtilizationRequest,
        AwsError,
        zio.aws.gamelift.model.DescribeFleetLocationUtilizationResponse.ReadOnly
      ]
  object DescribeGameServer
      extends Effect[
        DescribeGameServerRequest,
        AwsError,
        zio.aws.gamelift.model.DescribeGameServerResponse.ReadOnly
      ]
  object DeleteGameSessionQueue
      extends Effect[
        DeleteGameSessionQueueRequest,
        AwsError,
        zio.aws.gamelift.model.DeleteGameSessionQueueResponse.ReadOnly
      ]
  object StartFleetActions
      extends Effect[
        StartFleetActionsRequest,
        AwsError,
        zio.aws.gamelift.model.StartFleetActionsResponse.ReadOnly
      ]
  object RequestUploadCredentials
      extends Effect[
        RequestUploadCredentialsRequest,
        AwsError,
        zio.aws.gamelift.model.RequestUploadCredentialsResponse.ReadOnly
      ]
  object DeleteFleetLocations
      extends Effect[
        DeleteFleetLocationsRequest,
        AwsError,
        zio.aws.gamelift.model.DeleteFleetLocationsResponse.ReadOnly
      ]
  object DescribePlayerSessions
      extends Stream[
        DescribePlayerSessionsRequest,
        AwsError,
        zio.aws.gamelift.model.PlayerSession.ReadOnly
      ]
  object DescribePlayerSessionsPaginated
      extends Effect[
        DescribePlayerSessionsRequest,
        AwsError,
        zio.aws.gamelift.model.DescribePlayerSessionsResponse.ReadOnly
      ]
  object ResumeGameServerGroup
      extends Effect[
        ResumeGameServerGroupRequest,
        AwsError,
        zio.aws.gamelift.model.ResumeGameServerGroupResponse.ReadOnly
      ]
  object StartGameSessionPlacement
      extends Effect[
        StartGameSessionPlacementRequest,
        AwsError,
        zio.aws.gamelift.model.StartGameSessionPlacementResponse.ReadOnly
      ]
  object CreateVpcPeeringConnection
      extends Effect[
        CreateVpcPeeringConnectionRequest,
        AwsError,
        zio.aws.gamelift.model.CreateVpcPeeringConnectionResponse.ReadOnly
      ]
  object StopMatchmaking
      extends Effect[
        StopMatchmakingRequest,
        AwsError,
        zio.aws.gamelift.model.StopMatchmakingResponse.ReadOnly
      ]
  object ClaimGameServer
      extends Effect[
        ClaimGameServerRequest,
        AwsError,
        zio.aws.gamelift.model.ClaimGameServerResponse.ReadOnly
      ]
  object DescribeFleetCapacity
      extends Stream[
        DescribeFleetCapacityRequest,
        AwsError,
        zio.aws.gamelift.model.FleetCapacity.ReadOnly
      ]
  object DescribeFleetCapacityPaginated
      extends Effect[
        DescribeFleetCapacityRequest,
        AwsError,
        zio.aws.gamelift.model.DescribeFleetCapacityResponse.ReadOnly
      ]
  object ValidateMatchmakingRuleSet
      extends Effect[
        ValidateMatchmakingRuleSetRequest,
        AwsError,
        zio.aws.gamelift.model.ValidateMatchmakingRuleSetResponse.ReadOnly
      ]
  object DeleteMatchmakingConfiguration
      extends Effect[
        DeleteMatchmakingConfigurationRequest,
        AwsError,
        zio.aws.gamelift.model.DeleteMatchmakingConfigurationResponse.ReadOnly
      ]
  object DescribeFleetPortSettings
      extends Effect[
        DescribeFleetPortSettingsRequest,
        AwsError,
        zio.aws.gamelift.model.DescribeFleetPortSettingsResponse.ReadOnly
      ]
  object DescribeGameSessionQueues
      extends Stream[
        DescribeGameSessionQueuesRequest,
        AwsError,
        zio.aws.gamelift.model.GameSessionQueue.ReadOnly
      ]
  object DescribeGameSessionQueuesPaginated
      extends Effect[
        DescribeGameSessionQueuesRequest,
        AwsError,
        zio.aws.gamelift.model.DescribeGameSessionQueuesResponse.ReadOnly
      ]
  object CreateFleetLocations
      extends Effect[
        CreateFleetLocationsRequest,
        AwsError,
        zio.aws.gamelift.model.CreateFleetLocationsResponse.ReadOnly
      ]
  object CreateMatchmakingConfiguration
      extends Effect[
        CreateMatchmakingConfigurationRequest,
        AwsError,
        zio.aws.gamelift.model.CreateMatchmakingConfigurationResponse.ReadOnly
      ]
  object GetInstanceAccess
      extends Effect[
        GetInstanceAccessRequest,
        AwsError,
        zio.aws.gamelift.model.GetInstanceAccessResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.gamelift.model.ListTagsForResourceResponse.ReadOnly
      ]
  object UpdateBuild
      extends Effect[
        UpdateBuildRequest,
        AwsError,
        zio.aws.gamelift.model.UpdateBuildResponse.ReadOnly
      ]
  object DescribeEC2InstanceLimits
      extends Effect[
        DescribeEc2InstanceLimitsRequest,
        AwsError,
        zio.aws.gamelift.model.DescribeEc2InstanceLimitsResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.gamelift.model.TagResourceResponse.ReadOnly
      ]
  object DescribeBuild
      extends Effect[
        DescribeBuildRequest,
        AwsError,
        zio.aws.gamelift.model.DescribeBuildResponse.ReadOnly
      ]
  object DescribeGameSessions
      extends Stream[
        DescribeGameSessionsRequest,
        AwsError,
        zio.aws.gamelift.model.GameSession.ReadOnly
      ]
  object DescribeGameSessionsPaginated
      extends Effect[
        DescribeGameSessionsRequest,
        AwsError,
        zio.aws.gamelift.model.DescribeGameSessionsResponse.ReadOnly
      ]
  object DeleteAlias extends Effect[DeleteAliasRequest, AwsError, Unit]
  object DeregisterGameServer
      extends Effect[DeregisterGameServerRequest, AwsError, Unit]
  object CreateMatchmakingRuleSet
      extends Effect[
        CreateMatchmakingRuleSetRequest,
        AwsError,
        zio.aws.gamelift.model.CreateMatchmakingRuleSetResponse.ReadOnly
      ]
  object ListGameServerGroups
      extends Stream[
        ListGameServerGroupsRequest,
        AwsError,
        zio.aws.gamelift.model.GameServerGroup.ReadOnly
      ]
  object ListGameServerGroupsPaginated
      extends Effect[
        ListGameServerGroupsRequest,
        AwsError,
        zio.aws.gamelift.model.ListGameServerGroupsResponse.ReadOnly
      ]
  object CreateGameSession
      extends Effect[
        CreateGameSessionRequest,
        AwsError,
        zio.aws.gamelift.model.CreateGameSessionResponse.ReadOnly
      ]
  object DescribeFleetLocationAttributes
      extends Effect[DescribeFleetLocationAttributesRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.gamelift.model.DescribeFleetLocationAttributesResponse.ReadOnly,
        zio.aws.gamelift.model.LocationAttributes.ReadOnly
      ]]
  object DescribeFleetLocationAttributesPaginated
      extends Effect[
        DescribeFleetLocationAttributesRequest,
        AwsError,
        zio.aws.gamelift.model.DescribeFleetLocationAttributesResponse.ReadOnly
      ]
  object DescribeScript
      extends Effect[
        DescribeScriptRequest,
        AwsError,
        zio.aws.gamelift.model.DescribeScriptResponse.ReadOnly
      ]
  object DescribeGameServerInstances
      extends Stream[
        DescribeGameServerInstancesRequest,
        AwsError,
        zio.aws.gamelift.model.GameServerInstance.ReadOnly
      ]
  object DescribeGameServerInstancesPaginated
      extends Effect[
        DescribeGameServerInstancesRequest,
        AwsError,
        zio.aws.gamelift.model.DescribeGameServerInstancesResponse.ReadOnly
      ]
  object ListBuilds
      extends Stream[
        ListBuildsRequest,
        AwsError,
        zio.aws.gamelift.model.Build.ReadOnly
      ]
  object ListBuildsPaginated
      extends Effect[
        ListBuildsRequest,
        AwsError,
        zio.aws.gamelift.model.ListBuildsResponse.ReadOnly
      ]
  object AcceptMatch
      extends Effect[
        AcceptMatchRequest,
        AwsError,
        zio.aws.gamelift.model.AcceptMatchResponse.ReadOnly
      ]
  object DeleteMatchmakingRuleSet
      extends Effect[
        DeleteMatchmakingRuleSetRequest,
        AwsError,
        zio.aws.gamelift.model.DeleteMatchmakingRuleSetResponse.ReadOnly
      ]
  object UpdateMatchmakingConfiguration
      extends Effect[
        UpdateMatchmakingConfigurationRequest,
        AwsError,
        zio.aws.gamelift.model.UpdateMatchmakingConfigurationResponse.ReadOnly
      ]
  object ResolveAlias
      extends Effect[
        ResolveAliasRequest,
        AwsError,
        zio.aws.gamelift.model.ResolveAliasResponse.ReadOnly
      ]
  object DeleteScalingPolicy
      extends Effect[DeleteScalingPolicyRequest, AwsError, Unit]
  object ListGameServers
      extends Stream[
        ListGameServersRequest,
        AwsError,
        zio.aws.gamelift.model.GameServer.ReadOnly
      ]
  object ListGameServersPaginated
      extends Effect[
        ListGameServersRequest,
        AwsError,
        zio.aws.gamelift.model.ListGameServersResponse.ReadOnly
      ]
  object UpdateFleetCapacity
      extends Effect[
        UpdateFleetCapacityRequest,
        AwsError,
        zio.aws.gamelift.model.UpdateFleetCapacityResponse.ReadOnly
      ]
  object UpdateGameServerGroup
      extends Effect[
        UpdateGameServerGroupRequest,
        AwsError,
        zio.aws.gamelift.model.UpdateGameServerGroupResponse.ReadOnly
      ]
  object DescribeFleetEvents
      extends Stream[
        DescribeFleetEventsRequest,
        AwsError,
        zio.aws.gamelift.model.Event.ReadOnly
      ]
  object DescribeFleetEventsPaginated
      extends Effect[
        DescribeFleetEventsRequest,
        AwsError,
        zio.aws.gamelift.model.DescribeFleetEventsResponse.ReadOnly
      ]
  object UpdateScript
      extends Effect[
        UpdateScriptRequest,
        AwsError,
        zio.aws.gamelift.model.UpdateScriptResponse.ReadOnly
      ]
  object DescribeMatchmakingConfigurations
      extends Stream[
        DescribeMatchmakingConfigurationsRequest,
        AwsError,
        ReadOnly
      ]
  object DescribeMatchmakingConfigurationsPaginated
      extends Effect[
        DescribeMatchmakingConfigurationsRequest,
        AwsError,
        zio.aws.gamelift.model.DescribeMatchmakingConfigurationsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, GameLift] = ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new GameLift {
          val api: GameLiftAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : GameLift = this
          def deleteBuild(request: DeleteBuildRequest): IO[AwsError, Unit] =
            proxy(DeleteBuild, request)
          def describeVpcPeeringConnections(
              request: DescribeVpcPeeringConnectionsRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.DescribeVpcPeeringConnectionsResponse.ReadOnly
          ] = proxy(DescribeVpcPeeringConnections, request)
          def startMatchmaking(request: StartMatchmakingRequest): IO[
            AwsError,
            zio.aws.gamelift.model.StartMatchmakingResponse.ReadOnly
          ] = proxy(StartMatchmaking, request)
          def updateGameServer(request: UpdateGameServerRequest): IO[
            AwsError,
            zio.aws.gamelift.model.UpdateGameServerResponse.ReadOnly
          ] = proxy(UpdateGameServer, request)
          def updateFleetPortSettings(
              request: UpdateFleetPortSettingsRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.UpdateFleetPortSettingsResponse.ReadOnly
          ] = proxy(UpdateFleetPortSettings, request)
          def describeMatchmaking(request: DescribeMatchmakingRequest): IO[
            AwsError,
            zio.aws.gamelift.model.DescribeMatchmakingResponse.ReadOnly
          ] = proxy(DescribeMatchmaking, request)
          def createGameSessionQueue(
              request: CreateGameSessionQueueRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.CreateGameSessionQueueResponse.ReadOnly
          ] = proxy(CreateGameSessionQueue, request)
          def updateRuntimeConfiguration(
              request: UpdateRuntimeConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.UpdateRuntimeConfigurationResponse.ReadOnly
          ] = proxy(UpdateRuntimeConfiguration, request)
          def deleteScript(request: DeleteScriptRequest): IO[AwsError, Unit] =
            proxy(DeleteScript, request)
          def createPlayerSessions(request: CreatePlayerSessionsRequest): IO[
            AwsError,
            zio.aws.gamelift.model.CreatePlayerSessionsResponse.ReadOnly
          ] = proxy(CreatePlayerSessions, request)
          def stopFleetActions(request: StopFleetActionsRequest): IO[
            AwsError,
            zio.aws.gamelift.model.StopFleetActionsResponse.ReadOnly
          ] = proxy(StopFleetActions, request)
          def describeInstances(
              request: DescribeInstancesRequest
          ): ZStream[Any, AwsError, zio.aws.gamelift.model.Instance.ReadOnly] =
            rts.unsafeRun(proxy(DescribeInstances, request))
          def describeInstancesPaginated(request: DescribeInstancesRequest): IO[
            AwsError,
            zio.aws.gamelift.model.DescribeInstancesResponse.ReadOnly
          ] = proxy(DescribeInstancesPaginated, request)
          def suspendGameServerGroup(
              request: SuspendGameServerGroupRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.SuspendGameServerGroupResponse.ReadOnly
          ] = proxy(SuspendGameServerGroup, request)
          def describeGameSessionDetails(
              request: DescribeGameSessionDetailsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.gamelift.model.GameSessionDetail.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeGameSessionDetails, request))
          def describeGameSessionDetailsPaginated(
              request: DescribeGameSessionDetailsRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.DescribeGameSessionDetailsResponse.ReadOnly
          ] = proxy(DescribeGameSessionDetailsPaginated, request)
          def createGameServerGroup(request: CreateGameServerGroupRequest): IO[
            AwsError,
            zio.aws.gamelift.model.CreateGameServerGroupResponse.ReadOnly
          ] = proxy(CreateGameServerGroup, request)
          def createScript(request: CreateScriptRequest): IO[
            AwsError,
            zio.aws.gamelift.model.CreateScriptResponse.ReadOnly
          ] = proxy(CreateScript, request)
          def searchGameSessions(request: SearchGameSessionsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.gamelift.model.GameSession.ReadOnly
          ] = rts.unsafeRun(proxy(SearchGameSessions, request))
          def searchGameSessionsPaginated(
              request: SearchGameSessionsRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.SearchGameSessionsResponse.ReadOnly
          ] = proxy(SearchGameSessionsPaginated, request)
          def startMatchBackfill(request: StartMatchBackfillRequest): IO[
            AwsError,
            zio.aws.gamelift.model.StartMatchBackfillResponse.ReadOnly
          ] = proxy(StartMatchBackfill, request)
          def listFleets(
              request: ListFleetsRequest
          ): ZStream[Any, AwsError, FleetId] =
            rts.unsafeRun(proxy(ListFleets, request))
          def listFleetsPaginated(
              request: ListFleetsRequest
          ): IO[AwsError, zio.aws.gamelift.model.ListFleetsResponse.ReadOnly] =
            proxy(ListFleetsPaginated, request)
          def describeFleetUtilization(
              request: DescribeFleetUtilizationRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.gamelift.model.FleetUtilization.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeFleetUtilization, request))
          def describeFleetUtilizationPaginated(
              request: DescribeFleetUtilizationRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.DescribeFleetUtilizationResponse.ReadOnly
          ] = proxy(DescribeFleetUtilizationPaginated, request)
          def createPlayerSession(request: CreatePlayerSessionRequest): IO[
            AwsError,
            zio.aws.gamelift.model.CreatePlayerSessionResponse.ReadOnly
          ] = proxy(CreatePlayerSession, request)
          def describeGameSessionPlacement(
              request: DescribeGameSessionPlacementRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.DescribeGameSessionPlacementResponse.ReadOnly
          ] = proxy(DescribeGameSessionPlacement, request)
          def updateGameSession(request: UpdateGameSessionRequest): IO[
            AwsError,
            zio.aws.gamelift.model.UpdateGameSessionResponse.ReadOnly
          ] = proxy(UpdateGameSession, request)
          def createVpcPeeringAuthorization(
              request: CreateVpcPeeringAuthorizationRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.CreateVpcPeeringAuthorizationResponse.ReadOnly
          ] = proxy(CreateVpcPeeringAuthorization, request)
          def describeFleetLocationCapacity(
              request: DescribeFleetLocationCapacityRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.DescribeFleetLocationCapacityResponse.ReadOnly
          ] = proxy(DescribeFleetLocationCapacity, request)
          def listScripts(
              request: ListScriptsRequest
          ): ZStream[Any, AwsError, zio.aws.gamelift.model.Script.ReadOnly] =
            rts.unsafeRun(proxy(ListScripts, request))
          def listScriptsPaginated(
              request: ListScriptsRequest
          ): IO[AwsError, zio.aws.gamelift.model.ListScriptsResponse.ReadOnly] =
            proxy(ListScriptsPaginated, request)
          def describeVpcPeeringAuthorizations(
              request: DescribeVpcPeeringAuthorizationsRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.DescribeVpcPeeringAuthorizationsResponse.ReadOnly
          ] = proxy(DescribeVpcPeeringAuthorizations, request)
          def createBuild(
              request: CreateBuildRequest
          ): IO[AwsError, zio.aws.gamelift.model.CreateBuildResponse.ReadOnly] =
            proxy(CreateBuild, request)
          def deleteFleet(request: DeleteFleetRequest): IO[AwsError, Unit] =
            proxy(DeleteFleet, request)
          def describeMatchmakingRuleSets(
              request: DescribeMatchmakingRuleSetsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.gamelift.model.MatchmakingRuleSet.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeMatchmakingRuleSets, request))
          def describeMatchmakingRuleSetsPaginated(
              request: DescribeMatchmakingRuleSetsRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.DescribeMatchmakingRuleSetsResponse.ReadOnly
          ] = proxy(DescribeMatchmakingRuleSetsPaginated, request)
          def putScalingPolicy(request: PutScalingPolicyRequest): IO[
            AwsError,
            zio.aws.gamelift.model.PutScalingPolicyResponse.ReadOnly
          ] = proxy(PutScalingPolicy, request)
          def deleteGameServerGroup(request: DeleteGameServerGroupRequest): IO[
            AwsError,
            zio.aws.gamelift.model.DeleteGameServerGroupResponse.ReadOnly
          ] = proxy(DeleteGameServerGroup, request)
          def updateGameSessionQueue(
              request: UpdateGameSessionQueueRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.UpdateGameSessionQueueResponse.ReadOnly
          ] = proxy(UpdateGameSessionQueue, request)
          def stopGameSessionPlacement(
              request: StopGameSessionPlacementRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.StopGameSessionPlacementResponse.ReadOnly
          ] = proxy(StopGameSessionPlacement, request)
          def describeGameServerGroup(
              request: DescribeGameServerGroupRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.DescribeGameServerGroupResponse.ReadOnly
          ] = proxy(DescribeGameServerGroup, request)
          def deleteVpcPeeringAuthorization(
              request: DeleteVpcPeeringAuthorizationRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.DeleteVpcPeeringAuthorizationResponse.ReadOnly
          ] = proxy(DeleteVpcPeeringAuthorization, request)
          def registerGameServer(request: RegisterGameServerRequest): IO[
            AwsError,
            zio.aws.gamelift.model.RegisterGameServerResponse.ReadOnly
          ] = proxy(RegisterGameServer, request)
          def describeFleetAttributes(
              request: DescribeFleetAttributesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.gamelift.model.FleetAttributes.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeFleetAttributes, request))
          def describeFleetAttributesPaginated(
              request: DescribeFleetAttributesRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.DescribeFleetAttributesResponse.ReadOnly
          ] = proxy(DescribeFleetAttributesPaginated, request)
          def deleteVpcPeeringConnection(
              request: DeleteVpcPeeringConnectionRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.DeleteVpcPeeringConnectionResponse.ReadOnly
          ] = proxy(DeleteVpcPeeringConnection, request)
          def describeRuntimeConfiguration(
              request: DescribeRuntimeConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.DescribeRuntimeConfigurationResponse.ReadOnly
          ] = proxy(DescribeRuntimeConfiguration, request)
          def listAliases(
              request: ListAliasesRequest
          ): ZStream[Any, AwsError, zio.aws.gamelift.model.Alias.ReadOnly] =
            rts.unsafeRun(proxy(ListAliases, request))
          def listAliasesPaginated(
              request: ListAliasesRequest
          ): IO[AwsError, zio.aws.gamelift.model.ListAliasesResponse.ReadOnly] =
            proxy(ListAliasesPaginated, request)
          def getGameSessionLogUrl(request: GetGameSessionLogUrlRequest): IO[
            AwsError,
            zio.aws.gamelift.model.GetGameSessionLogUrlResponse.ReadOnly
          ] = proxy(GetGameSessionLogUrl, request)
          def describeAlias(request: DescribeAliasRequest): IO[
            AwsError,
            zio.aws.gamelift.model.DescribeAliasResponse.ReadOnly
          ] = proxy(DescribeAlias, request)
          def createFleet(
              request: CreateFleetRequest
          ): IO[AwsError, zio.aws.gamelift.model.CreateFleetResponse.ReadOnly] =
            proxy(CreateFleet, request)
          def describeScalingPolicies(
              request: DescribeScalingPoliciesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.gamelift.model.ScalingPolicy.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeScalingPolicies, request))
          def describeScalingPoliciesPaginated(
              request: DescribeScalingPoliciesRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.DescribeScalingPoliciesResponse.ReadOnly
          ] = proxy(DescribeScalingPoliciesPaginated, request)
          def updateAlias(
              request: UpdateAliasRequest
          ): IO[AwsError, zio.aws.gamelift.model.UpdateAliasResponse.ReadOnly] =
            proxy(UpdateAlias, request)
          def untagResource(request: UntagResourceRequest): IO[
            AwsError,
            zio.aws.gamelift.model.UntagResourceResponse.ReadOnly
          ] = proxy(UntagResource, request)
          def createAlias(
              request: CreateAliasRequest
          ): IO[AwsError, zio.aws.gamelift.model.CreateAliasResponse.ReadOnly] =
            proxy(CreateAlias, request)
          def updateFleetAttributes(request: UpdateFleetAttributesRequest): IO[
            AwsError,
            zio.aws.gamelift.model.UpdateFleetAttributesResponse.ReadOnly
          ] = proxy(UpdateFleetAttributes, request)
          def describeFleetLocationUtilization(
              request: DescribeFleetLocationUtilizationRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.DescribeFleetLocationUtilizationResponse.ReadOnly
          ] = proxy(DescribeFleetLocationUtilization, request)
          def describeGameServer(request: DescribeGameServerRequest): IO[
            AwsError,
            zio.aws.gamelift.model.DescribeGameServerResponse.ReadOnly
          ] = proxy(DescribeGameServer, request)
          def deleteGameSessionQueue(
              request: DeleteGameSessionQueueRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.DeleteGameSessionQueueResponse.ReadOnly
          ] = proxy(DeleteGameSessionQueue, request)
          def startFleetActions(request: StartFleetActionsRequest): IO[
            AwsError,
            zio.aws.gamelift.model.StartFleetActionsResponse.ReadOnly
          ] = proxy(StartFleetActions, request)
          def requestUploadCredentials(
              request: RequestUploadCredentialsRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.RequestUploadCredentialsResponse.ReadOnly
          ] = proxy(RequestUploadCredentials, request)
          def deleteFleetLocations(request: DeleteFleetLocationsRequest): IO[
            AwsError,
            zio.aws.gamelift.model.DeleteFleetLocationsResponse.ReadOnly
          ] = proxy(DeleteFleetLocations, request)
          def describePlayerSessions(
              request: DescribePlayerSessionsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.gamelift.model.PlayerSession.ReadOnly
          ] = rts.unsafeRun(proxy(DescribePlayerSessions, request))
          def describePlayerSessionsPaginated(
              request: DescribePlayerSessionsRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.DescribePlayerSessionsResponse.ReadOnly
          ] = proxy(DescribePlayerSessionsPaginated, request)
          def resumeGameServerGroup(request: ResumeGameServerGroupRequest): IO[
            AwsError,
            zio.aws.gamelift.model.ResumeGameServerGroupResponse.ReadOnly
          ] = proxy(ResumeGameServerGroup, request)
          def startGameSessionPlacement(
              request: StartGameSessionPlacementRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.StartGameSessionPlacementResponse.ReadOnly
          ] = proxy(StartGameSessionPlacement, request)
          def createVpcPeeringConnection(
              request: CreateVpcPeeringConnectionRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.CreateVpcPeeringConnectionResponse.ReadOnly
          ] = proxy(CreateVpcPeeringConnection, request)
          def stopMatchmaking(request: StopMatchmakingRequest): IO[
            AwsError,
            zio.aws.gamelift.model.StopMatchmakingResponse.ReadOnly
          ] = proxy(StopMatchmaking, request)
          def claimGameServer(request: ClaimGameServerRequest): IO[
            AwsError,
            zio.aws.gamelift.model.ClaimGameServerResponse.ReadOnly
          ] = proxy(ClaimGameServer, request)
          def describeFleetCapacity(
              request: DescribeFleetCapacityRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.gamelift.model.FleetCapacity.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeFleetCapacity, request))
          def describeFleetCapacityPaginated(
              request: DescribeFleetCapacityRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.DescribeFleetCapacityResponse.ReadOnly
          ] = proxy(DescribeFleetCapacityPaginated, request)
          def validateMatchmakingRuleSet(
              request: ValidateMatchmakingRuleSetRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.ValidateMatchmakingRuleSetResponse.ReadOnly
          ] = proxy(ValidateMatchmakingRuleSet, request)
          def deleteMatchmakingConfiguration(
              request: DeleteMatchmakingConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.DeleteMatchmakingConfigurationResponse.ReadOnly
          ] = proxy(DeleteMatchmakingConfiguration, request)
          def describeFleetPortSettings(
              request: DescribeFleetPortSettingsRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.DescribeFleetPortSettingsResponse.ReadOnly
          ] = proxy(DescribeFleetPortSettings, request)
          def describeGameSessionQueues(
              request: DescribeGameSessionQueuesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.gamelift.model.GameSessionQueue.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeGameSessionQueues, request))
          def describeGameSessionQueuesPaginated(
              request: DescribeGameSessionQueuesRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.DescribeGameSessionQueuesResponse.ReadOnly
          ] = proxy(DescribeGameSessionQueuesPaginated, request)
          def createFleetLocations(request: CreateFleetLocationsRequest): IO[
            AwsError,
            zio.aws.gamelift.model.CreateFleetLocationsResponse.ReadOnly
          ] = proxy(CreateFleetLocations, request)
          def createMatchmakingConfiguration(
              request: CreateMatchmakingConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.CreateMatchmakingConfigurationResponse.ReadOnly
          ] = proxy(CreateMatchmakingConfiguration, request)
          def getInstanceAccess(request: GetInstanceAccessRequest): IO[
            AwsError,
            zio.aws.gamelift.model.GetInstanceAccessResponse.ReadOnly
          ] = proxy(GetInstanceAccess, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.gamelift.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def updateBuild(
              request: UpdateBuildRequest
          ): IO[AwsError, zio.aws.gamelift.model.UpdateBuildResponse.ReadOnly] =
            proxy(UpdateBuild, request)
          def describeEC2InstanceLimits(
              request: DescribeEc2InstanceLimitsRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.DescribeEc2InstanceLimitsResponse.ReadOnly
          ] = proxy(DescribeEC2InstanceLimits, request)
          def tagResource(
              request: TagResourceRequest
          ): IO[AwsError, zio.aws.gamelift.model.TagResourceResponse.ReadOnly] =
            proxy(TagResource, request)
          def describeBuild(request: DescribeBuildRequest): IO[
            AwsError,
            zio.aws.gamelift.model.DescribeBuildResponse.ReadOnly
          ] = proxy(DescribeBuild, request)
          def describeGameSessions(
              request: DescribeGameSessionsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.gamelift.model.GameSession.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeGameSessions, request))
          def describeGameSessionsPaginated(
              request: DescribeGameSessionsRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.DescribeGameSessionsResponse.ReadOnly
          ] = proxy(DescribeGameSessionsPaginated, request)
          def deleteAlias(request: DeleteAliasRequest): IO[AwsError, Unit] =
            proxy(DeleteAlias, request)
          def deregisterGameServer(
              request: DeregisterGameServerRequest
          ): IO[AwsError, Unit] = proxy(DeregisterGameServer, request)
          def createMatchmakingRuleSet(
              request: CreateMatchmakingRuleSetRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.CreateMatchmakingRuleSetResponse.ReadOnly
          ] = proxy(CreateMatchmakingRuleSet, request)
          def listGameServerGroups(
              request: ListGameServerGroupsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.gamelift.model.GameServerGroup.ReadOnly
          ] = rts.unsafeRun(proxy(ListGameServerGroups, request))
          def listGameServerGroupsPaginated(
              request: ListGameServerGroupsRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.ListGameServerGroupsResponse.ReadOnly
          ] = proxy(ListGameServerGroupsPaginated, request)
          def createGameSession(request: CreateGameSessionRequest): IO[
            AwsError,
            zio.aws.gamelift.model.CreateGameSessionResponse.ReadOnly
          ] = proxy(CreateGameSession, request)
          def describeFleetLocationAttributes(
              request: DescribeFleetLocationAttributesRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.gamelift.model.DescribeFleetLocationAttributesResponse.ReadOnly,
            zio.aws.gamelift.model.LocationAttributes.ReadOnly
          ]] = proxy(DescribeFleetLocationAttributes, request)
          def describeFleetLocationAttributesPaginated(
              request: DescribeFleetLocationAttributesRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.DescribeFleetLocationAttributesResponse.ReadOnly
          ] = proxy(DescribeFleetLocationAttributesPaginated, request)
          def describeScript(request: DescribeScriptRequest): IO[
            AwsError,
            zio.aws.gamelift.model.DescribeScriptResponse.ReadOnly
          ] = proxy(DescribeScript, request)
          def describeGameServerInstances(
              request: DescribeGameServerInstancesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.gamelift.model.GameServerInstance.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeGameServerInstances, request))
          def describeGameServerInstancesPaginated(
              request: DescribeGameServerInstancesRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.DescribeGameServerInstancesResponse.ReadOnly
          ] = proxy(DescribeGameServerInstancesPaginated, request)
          def listBuilds(
              request: ListBuildsRequest
          ): ZStream[Any, AwsError, zio.aws.gamelift.model.Build.ReadOnly] =
            rts.unsafeRun(proxy(ListBuilds, request))
          def listBuildsPaginated(
              request: ListBuildsRequest
          ): IO[AwsError, zio.aws.gamelift.model.ListBuildsResponse.ReadOnly] =
            proxy(ListBuildsPaginated, request)
          def acceptMatch(
              request: AcceptMatchRequest
          ): IO[AwsError, zio.aws.gamelift.model.AcceptMatchResponse.ReadOnly] =
            proxy(AcceptMatch, request)
          def deleteMatchmakingRuleSet(
              request: DeleteMatchmakingRuleSetRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.DeleteMatchmakingRuleSetResponse.ReadOnly
          ] = proxy(DeleteMatchmakingRuleSet, request)
          def updateMatchmakingConfiguration(
              request: UpdateMatchmakingConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.UpdateMatchmakingConfigurationResponse.ReadOnly
          ] = proxy(UpdateMatchmakingConfiguration, request)
          def resolveAlias(request: ResolveAliasRequest): IO[
            AwsError,
            zio.aws.gamelift.model.ResolveAliasResponse.ReadOnly
          ] = proxy(ResolveAlias, request)
          def deleteScalingPolicy(
              request: DeleteScalingPolicyRequest
          ): IO[AwsError, Unit] = proxy(DeleteScalingPolicy, request)
          def listGameServers(request: ListGameServersRequest): ZStream[
            Any,
            AwsError,
            zio.aws.gamelift.model.GameServer.ReadOnly
          ] = rts.unsafeRun(proxy(ListGameServers, request))
          def listGameServersPaginated(request: ListGameServersRequest): IO[
            AwsError,
            zio.aws.gamelift.model.ListGameServersResponse.ReadOnly
          ] = proxy(ListGameServersPaginated, request)
          def updateFleetCapacity(request: UpdateFleetCapacityRequest): IO[
            AwsError,
            zio.aws.gamelift.model.UpdateFleetCapacityResponse.ReadOnly
          ] = proxy(UpdateFleetCapacity, request)
          def updateGameServerGroup(request: UpdateGameServerGroupRequest): IO[
            AwsError,
            zio.aws.gamelift.model.UpdateGameServerGroupResponse.ReadOnly
          ] = proxy(UpdateGameServerGroup, request)
          def describeFleetEvents(
              request: DescribeFleetEventsRequest
          ): ZStream[Any, AwsError, zio.aws.gamelift.model.Event.ReadOnly] =
            rts.unsafeRun(proxy(DescribeFleetEvents, request))
          def describeFleetEventsPaginated(
              request: DescribeFleetEventsRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.DescribeFleetEventsResponse.ReadOnly
          ] = proxy(DescribeFleetEventsPaginated, request)
          def updateScript(request: UpdateScriptRequest): IO[
            AwsError,
            zio.aws.gamelift.model.UpdateScriptResponse.ReadOnly
          ] = proxy(UpdateScript, request)
          def describeMatchmakingConfigurations(
              request: DescribeMatchmakingConfigurationsRequest
          ): ZStream[Any, AwsError, ReadOnly] =
            rts.unsafeRun(proxy(DescribeMatchmakingConfigurations, request))
          def describeMatchmakingConfigurationsPaginated(
              request: DescribeMatchmakingConfigurationsRequest
          ): IO[
            AwsError,
            zio.aws.gamelift.model.DescribeMatchmakingConfigurationsResponse.ReadOnly
          ] = proxy(DescribeMatchmakingConfigurationsPaginated, request)
        }
      }
    }
    .toLayer
}
