package zio.aws.gamelift.model
import scala.jdk.CollectionConverters._
sealed trait AcceptanceType {
  def unwrap: software.amazon.awssdk.services.gamelift.model.AcceptanceType
}
object AcceptanceType {
  def wrap(
      value: software.amazon.awssdk.services.gamelift.model.AcceptanceType
  ): zio.aws.gamelift.model.AcceptanceType = value match {
    case software.amazon.awssdk.services.gamelift.model.AcceptanceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.gamelift.model.AcceptanceType.ACCEPT =>
      val r = ACCEPT
      r
    case software.amazon.awssdk.services.gamelift.model.AcceptanceType.REJECT =>
      val r = REJECT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.gamelift.model.AcceptanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.AcceptanceType =
      software.amazon.awssdk.services.gamelift.model.AcceptanceType.UNKNOWN_TO_SDK_VERSION
  }
  case object ACCEPT extends zio.aws.gamelift.model.AcceptanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.AcceptanceType =
      software.amazon.awssdk.services.gamelift.model.AcceptanceType.ACCEPT
  }
  case object REJECT extends zio.aws.gamelift.model.AcceptanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.AcceptanceType =
      software.amazon.awssdk.services.gamelift.model.AcceptanceType.REJECT
  }
}
