package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.gamelift.model.primitives.{
  AliasArn,
  FreeText,
  Timestamp,
  AliasId,
  NonBlankAndLengthConstraintString
}
import scala.jdk.CollectionConverters._
final case class Alias(
    aliasId: Option[AliasId] = None,
    name: Option[NonBlankAndLengthConstraintString] = None,
    aliasArn: Option[AliasArn] = None,
    description: Option[FreeText] = None,
    routingStrategy: Option[zio.aws.gamelift.model.RoutingStrategy] = None,
    creationTime: Option[Timestamp] = None,
    lastUpdatedTime: Option[Timestamp] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.gamelift.model.Alias = {
    import Alias.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.Alias
      .builder()
      .optionallyWith(
        aliasId.map(value => AliasId.unwrap(value): java.lang.String)
      )(_.aliasId)
      .optionallyWith(
        name.map(value =>
          NonBlankAndLengthConstraintString.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        aliasArn.map(value => AliasArn.unwrap(value): java.lang.String)
      )(_.aliasArn)
      .optionallyWith(
        description.map(value => FreeText.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(routingStrategy.map(value => value.buildAwsValue()))(
        _.routingStrategy
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastUpdatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.Alias.ReadOnly =
    zio.aws.gamelift.model.Alias.wrap(buildAwsValue())
}
object Alias {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.gamelift.model.Alias] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.Alias = zio.aws.gamelift.model.Alias(
      aliasId.map(value => value),
      name.map(value => value),
      aliasArn.map(value => value),
      description.map(value => value),
      routingStrategy.map(value => value.asEditable),
      creationTime.map(value => value),
      lastUpdatedTime.map(value => value)
    )
    def aliasId: Option[AliasId]
    def name: Option[NonBlankAndLengthConstraintString]
    def aliasArn: Option[AliasArn]
    def description: Option[FreeText]
    def routingStrategy: Option[zio.aws.gamelift.model.RoutingStrategy.ReadOnly]
    def creationTime: Option[Timestamp]
    def lastUpdatedTime: Option[Timestamp]
    def getAliasId: ZIO[Any, AwsError, AliasId] =
      AwsError.unwrapOptionField("aliasId", aliasId)
    def getName: ZIO[Any, AwsError, NonBlankAndLengthConstraintString] =
      AwsError.unwrapOptionField("name", name)
    def getAliasArn: ZIO[Any, AwsError, AliasArn] =
      AwsError.unwrapOptionField("aliasArn", aliasArn)
    def getDescription: ZIO[Any, AwsError, FreeText] =
      AwsError.unwrapOptionField("description", description)
    def getRoutingStrategy
        : ZIO[Any, AwsError, zio.aws.gamelift.model.RoutingStrategy.ReadOnly] =
      AwsError.unwrapOptionField("routingStrategy", routingStrategy)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastUpdatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.Alias
  ) extends zio.aws.gamelift.model.Alias.ReadOnly {
    override val aliasId: Option[AliasId] = scala
      .Option(impl.aliasId())
      .map(value => zio.aws.gamelift.model.primitives.AliasId(value))
    override val name: Option[NonBlankAndLengthConstraintString] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.gamelift.model.primitives
          .NonBlankAndLengthConstraintString(value)
      )
    override val aliasArn: Option[AliasArn] = scala
      .Option(impl.aliasArn())
      .map(value => zio.aws.gamelift.model.primitives.AliasArn(value))
    override val description: Option[FreeText] = scala
      .Option(impl.description())
      .map(value => zio.aws.gamelift.model.primitives.FreeText(value))
    override val routingStrategy
        : Option[zio.aws.gamelift.model.RoutingStrategy.ReadOnly] = scala
      .Option(impl.routingStrategy())
      .map(value => zio.aws.gamelift.model.RoutingStrategy.wrap(value))
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.gamelift.model.primitives.Timestamp(value))
    override val lastUpdatedTime: Option[Timestamp] = scala
      .Option(impl.lastUpdatedTime())
      .map(value => zio.aws.gamelift.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.Alias
  ): zio.aws.gamelift.model.Alias.ReadOnly = new Wrapper(impl)
}
