package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{DoubleObject, NonZeroAndMaxString}
import scala.jdk.CollectionConverters._
final case class AttributeValue(
    s: Option[NonZeroAndMaxString] = None,
    n: Option[DoubleObject] = None,
    sl: Option[Iterable[NonZeroAndMaxString]] = None,
    sdm: Option[Map[NonZeroAndMaxString, DoubleObject]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.AttributeValue = {
    import AttributeValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.AttributeValue
      .builder()
      .optionallyWith(
        s.map(value => NonZeroAndMaxString.unwrap(value): java.lang.String)
      )(_.s)
      .optionallyWith(
        n.map(value => DoubleObject.unwrap(value): java.lang.Double)
      )(_.n)
      .optionallyWith(
        sl.map(value =>
          value.map { item =>
            NonZeroAndMaxString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.sl)
      .optionallyWith(
        sdm.map(value =>
          value
            .map({ case (key, value) =>
              (NonZeroAndMaxString
                .unwrap(key): java.lang.String) -> (DoubleObject
                .unwrap(value): java.lang.Double)
            })
            .asJava
        )
      )(_.sdm)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.AttributeValue.ReadOnly =
    zio.aws.gamelift.model.AttributeValue.wrap(buildAwsValue())
}
object AttributeValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.AttributeValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.AttributeValue =
      zio.aws.gamelift.model.AttributeValue(
        s.map(value => value),
        n.map(value => value),
        sl.map(value => value),
        sdm.map(value => value)
      )
    def s: Option[NonZeroAndMaxString]
    def n: Option[DoubleObject]
    def sl: Option[List[NonZeroAndMaxString]]
    def sdm: Option[Map[NonZeroAndMaxString, DoubleObject]]
    def getS: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("s", s)
    def getN: ZIO[Any, AwsError, DoubleObject] =
      AwsError.unwrapOptionField("n", n)
    def getSl: ZIO[Any, AwsError, List[NonZeroAndMaxString]] =
      AwsError.unwrapOptionField("sl", sl)
    def getSdm: ZIO[Any, AwsError, Map[NonZeroAndMaxString, DoubleObject]] =
      AwsError.unwrapOptionField("sdm", sdm)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.AttributeValue
  ) extends zio.aws.gamelift.model.AttributeValue.ReadOnly {
    override val s: Option[NonZeroAndMaxString] = scala
      .Option(impl.s())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val n: Option[DoubleObject] = scala
      .Option(impl.n())
      .map(value => zio.aws.gamelift.model.primitives.DoubleObject(value))
    override val sl: Option[List[NonZeroAndMaxString]] = scala
      .Option(impl.sl())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(item)
        }.toList
      )
    override val sdm: Option[Map[NonZeroAndMaxString, DoubleObject]] = scala
      .Option(impl.sdm())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.gamelift.model.primitives.NonZeroAndMaxString(
              key
            ) -> zio.aws.gamelift.model.primitives.DoubleObject(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.AttributeValue
  ): zio.aws.gamelift.model.AttributeValue.ReadOnly = new Wrapper(impl)
}
