package zio.aws.gamelift.model
import scala.jdk.CollectionConverters._
sealed trait BalancingStrategy {
  def unwrap: software.amazon.awssdk.services.gamelift.model.BalancingStrategy
}
object BalancingStrategy {
  def wrap(
      value: software.amazon.awssdk.services.gamelift.model.BalancingStrategy
  ): zio.aws.gamelift.model.BalancingStrategy = value match {
    case software.amazon.awssdk.services.gamelift.model.BalancingStrategy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.gamelift.model.BalancingStrategy.SPOT_ONLY =>
      val r = SPOT_ONLY
      r
    case software.amazon.awssdk.services.gamelift.model.BalancingStrategy.SPOT_PREFERRED =>
      val r = SPOT_PREFERRED
      r
    case software.amazon.awssdk.services.gamelift.model.BalancingStrategy.ON_DEMAND_ONLY =>
      val r = ON_DEMAND_ONLY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.gamelift.model.BalancingStrategy {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.BalancingStrategy =
      software.amazon.awssdk.services.gamelift.model.BalancingStrategy.UNKNOWN_TO_SDK_VERSION
  }
  case object SPOT_ONLY extends zio.aws.gamelift.model.BalancingStrategy {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.BalancingStrategy =
      software.amazon.awssdk.services.gamelift.model.BalancingStrategy.SPOT_ONLY
  }
  case object SPOT_PREFERRED extends zio.aws.gamelift.model.BalancingStrategy {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.BalancingStrategy =
      software.amazon.awssdk.services.gamelift.model.BalancingStrategy.SPOT_PREFERRED
  }
  case object ON_DEMAND_ONLY extends zio.aws.gamelift.model.BalancingStrategy {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.BalancingStrategy =
      software.amazon.awssdk.services.gamelift.model.BalancingStrategy.ON_DEMAND_ONLY
  }
}
