package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.gamelift.model.primitives.{
  FreeText,
  PositiveLong,
  Timestamp,
  BuildArn,
  BuildId
}
import scala.jdk.CollectionConverters._
final case class Build(
    buildId: Option[BuildId] = None,
    buildArn: Option[BuildArn] = None,
    name: Option[FreeText] = None,
    version: Option[FreeText] = None,
    status: Option[zio.aws.gamelift.model.BuildStatus] = None,
    sizeOnDisk: Option[PositiveLong] = None,
    operatingSystem: Option[zio.aws.gamelift.model.OperatingSystem] = None,
    creationTime: Option[Timestamp] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.gamelift.model.Build = {
    import Build.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.Build
      .builder()
      .optionallyWith(
        buildId.map(value => BuildId.unwrap(value): java.lang.String)
      )(_.buildId)
      .optionallyWith(
        buildArn.map(value => BuildArn.unwrap(value): java.lang.String)
      )(_.buildArn)
      .optionallyWith(
        name.map(value => FreeText.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        version.map(value => FreeText.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        sizeOnDisk.map(value => PositiveLong.unwrap(value): java.lang.Long)
      )(_.sizeOnDisk)
      .optionallyWith(operatingSystem.map(value => value.unwrap))(
        _.operatingSystem
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.Build.ReadOnly =
    zio.aws.gamelift.model.Build.wrap(buildAwsValue())
}
object Build {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.gamelift.model.Build] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.Build = zio.aws.gamelift.model.Build(
      buildId.map(value => value),
      buildArn.map(value => value),
      name.map(value => value),
      version.map(value => value),
      status.map(value => value),
      sizeOnDisk.map(value => value),
      operatingSystem.map(value => value),
      creationTime.map(value => value)
    )
    def buildId: Option[BuildId]
    def buildArn: Option[BuildArn]
    def name: Option[FreeText]
    def version: Option[FreeText]
    def status: Option[zio.aws.gamelift.model.BuildStatus]
    def sizeOnDisk: Option[PositiveLong]
    def operatingSystem: Option[zio.aws.gamelift.model.OperatingSystem]
    def creationTime: Option[Timestamp]
    def getBuildId: ZIO[Any, AwsError, BuildId] =
      AwsError.unwrapOptionField("buildId", buildId)
    def getBuildArn: ZIO[Any, AwsError, BuildArn] =
      AwsError.unwrapOptionField("buildArn", buildArn)
    def getName: ZIO[Any, AwsError, FreeText] =
      AwsError.unwrapOptionField("name", name)
    def getVersion: ZIO[Any, AwsError, FreeText] =
      AwsError.unwrapOptionField("version", version)
    def getStatus: ZIO[Any, AwsError, zio.aws.gamelift.model.BuildStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSizeOnDisk: ZIO[Any, AwsError, PositiveLong] =
      AwsError.unwrapOptionField("sizeOnDisk", sizeOnDisk)
    def getOperatingSystem
        : ZIO[Any, AwsError, zio.aws.gamelift.model.OperatingSystem] =
      AwsError.unwrapOptionField("operatingSystem", operatingSystem)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.Build
  ) extends zio.aws.gamelift.model.Build.ReadOnly {
    override val buildId: Option[BuildId] = scala
      .Option(impl.buildId())
      .map(value => zio.aws.gamelift.model.primitives.BuildId(value))
    override val buildArn: Option[BuildArn] = scala
      .Option(impl.buildArn())
      .map(value => zio.aws.gamelift.model.primitives.BuildArn(value))
    override val name: Option[FreeText] = scala
      .Option(impl.name())
      .map(value => zio.aws.gamelift.model.primitives.FreeText(value))
    override val version: Option[FreeText] = scala
      .Option(impl.version())
      .map(value => zio.aws.gamelift.model.primitives.FreeText(value))
    override val status: Option[zio.aws.gamelift.model.BuildStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.gamelift.model.BuildStatus.wrap(value))
    override val sizeOnDisk: Option[PositiveLong] = scala
      .Option(impl.sizeOnDisk())
      .map(value => zio.aws.gamelift.model.primitives.PositiveLong(value))
    override val operatingSystem
        : Option[zio.aws.gamelift.model.OperatingSystem] = scala
      .Option(impl.operatingSystem())
      .map(value => zio.aws.gamelift.model.OperatingSystem.wrap(value))
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.gamelift.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.Build
  ): zio.aws.gamelift.model.Build.ReadOnly = new Wrapper(impl)
}
