package zio.aws.gamelift.model
import scala.jdk.CollectionConverters._
sealed trait CertificateType {
  def unwrap: software.amazon.awssdk.services.gamelift.model.CertificateType
}
object CertificateType {
  def wrap(
      value: software.amazon.awssdk.services.gamelift.model.CertificateType
  ): zio.aws.gamelift.model.CertificateType = value match {
    case software.amazon.awssdk.services.gamelift.model.CertificateType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.gamelift.model.CertificateType.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.gamelift.model.CertificateType.GENERATED =>
      val r = GENERATED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.gamelift.model.CertificateType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.CertificateType =
      software.amazon.awssdk.services.gamelift.model.CertificateType.UNKNOWN_TO_SDK_VERSION
  }
  case object DISABLED extends zio.aws.gamelift.model.CertificateType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.CertificateType =
      software.amazon.awssdk.services.gamelift.model.CertificateType.DISABLED
  }
  case object GENERATED extends zio.aws.gamelift.model.CertificateType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.CertificateType =
      software.amazon.awssdk.services.gamelift.model.CertificateType.GENERATED
  }
}
