package zio.aws.gamelift.model
import scala.jdk.CollectionConverters._
sealed trait ComparisonOperatorType {
  def unwrap
      : software.amazon.awssdk.services.gamelift.model.ComparisonOperatorType
}
object ComparisonOperatorType {
  def wrap(
      value: software.amazon.awssdk.services.gamelift.model.ComparisonOperatorType
  ): zio.aws.gamelift.model.ComparisonOperatorType = value match {
    case software.amazon.awssdk.services.gamelift.model.ComparisonOperatorType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.gamelift.model.ComparisonOperatorType.GREATER_THAN_OR_EQUAL_TO_THRESHOLD =>
      val r = GreaterThanOrEqualToThreshold
      r
    case software.amazon.awssdk.services.gamelift.model.ComparisonOperatorType.GREATER_THAN_THRESHOLD =>
      val r = GreaterThanThreshold
      r
    case software.amazon.awssdk.services.gamelift.model.ComparisonOperatorType.LESS_THAN_THRESHOLD =>
      val r = LessThanThreshold
      r
    case software.amazon.awssdk.services.gamelift.model.ComparisonOperatorType.LESS_THAN_OR_EQUAL_TO_THRESHOLD =>
      val r = LessThanOrEqualToThreshold
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.gamelift.model.ComparisonOperatorType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.ComparisonOperatorType =
      software.amazon.awssdk.services.gamelift.model.ComparisonOperatorType.UNKNOWN_TO_SDK_VERSION
  }
  case object GreaterThanOrEqualToThreshold
      extends zio.aws.gamelift.model.ComparisonOperatorType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.ComparisonOperatorType =
      software.amazon.awssdk.services.gamelift.model.ComparisonOperatorType.GREATER_THAN_OR_EQUAL_TO_THRESHOLD
  }
  case object GreaterThanThreshold
      extends zio.aws.gamelift.model.ComparisonOperatorType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.ComparisonOperatorType =
      software.amazon.awssdk.services.gamelift.model.ComparisonOperatorType.GREATER_THAN_THRESHOLD
  }
  case object LessThanThreshold
      extends zio.aws.gamelift.model.ComparisonOperatorType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.ComparisonOperatorType =
      software.amazon.awssdk.services.gamelift.model.ComparisonOperatorType.LESS_THAN_THRESHOLD
  }
  case object LessThanOrEqualToThreshold
      extends zio.aws.gamelift.model.ComparisonOperatorType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.ComparisonOperatorType =
      software.amazon.awssdk.services.gamelift.model.ComparisonOperatorType.LESS_THAN_OR_EQUAL_TO_THRESHOLD
  }
}
