package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{
  ScriptIdOrArn,
  BuildIdOrArn,
  LaunchParametersStringModel,
  MetricGroup,
  NonZeroAndMaxString,
  LaunchPathStringModel,
  NonEmptyString
}
import scala.jdk.CollectionConverters._
final case class CreateFleetRequest(
    name: NonZeroAndMaxString,
    description: Option[NonZeroAndMaxString] = None,
    buildId: Option[BuildIdOrArn] = None,
    scriptId: Option[ScriptIdOrArn] = None,
    serverLaunchPath: Option[LaunchPathStringModel] = None,
    serverLaunchParameters: Option[LaunchParametersStringModel] = None,
    logPaths: Option[Iterable[NonZeroAndMaxString]] = None,
    ec2InstanceType: zio.aws.gamelift.model.EC2InstanceType,
    ec2InboundPermissions: Option[
      Iterable[zio.aws.gamelift.model.IpPermission]
    ] = None,
    newGameSessionProtectionPolicy: Option[
      zio.aws.gamelift.model.ProtectionPolicy
    ] = None,
    runtimeConfiguration: Option[zio.aws.gamelift.model.RuntimeConfiguration] =
      None,
    resourceCreationLimitPolicy: Option[
      zio.aws.gamelift.model.ResourceCreationLimitPolicy
    ] = None,
    metricGroups: Option[Iterable[MetricGroup]] = None,
    peerVpcAwsAccountId: Option[NonZeroAndMaxString] = None,
    peerVpcId: Option[NonZeroAndMaxString] = None,
    fleetType: Option[zio.aws.gamelift.model.FleetType] = None,
    instanceRoleArn: Option[NonEmptyString] = None,
    certificateConfiguration: Option[
      zio.aws.gamelift.model.CertificateConfiguration
    ] = None,
    locations: Option[Iterable[zio.aws.gamelift.model.LocationConfiguration]] =
      None,
    tags: Option[Iterable[zio.aws.gamelift.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.CreateFleetRequest = {
    import CreateFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.CreateFleetRequest
      .builder()
      .name(NonZeroAndMaxString.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        buildId.map(value => BuildIdOrArn.unwrap(value): java.lang.String)
      )(_.buildId)
      .optionallyWith(
        scriptId.map(value => ScriptIdOrArn.unwrap(value): java.lang.String)
      )(_.scriptId)
      .optionallyWith(
        serverLaunchPath.map(value =>
          LaunchPathStringModel.unwrap(value): java.lang.String
        )
      )(_.serverLaunchPath)
      .optionallyWith(
        serverLaunchParameters.map(value =>
          LaunchParametersStringModel.unwrap(value): java.lang.String
        )
      )(_.serverLaunchParameters)
      .optionallyWith(
        logPaths.map(value =>
          value.map { item =>
            NonZeroAndMaxString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.logPaths)
      .ec2InstanceType(ec2InstanceType.unwrap)
      .optionallyWith(
        ec2InboundPermissions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ec2InboundPermissions)
      .optionallyWith(
        newGameSessionProtectionPolicy.map(value => value.unwrap)
      )(_.newGameSessionProtectionPolicy)
      .optionallyWith(runtimeConfiguration.map(value => value.buildAwsValue()))(
        _.runtimeConfiguration
      )
      .optionallyWith(
        resourceCreationLimitPolicy.map(value => value.buildAwsValue())
      )(_.resourceCreationLimitPolicy)
      .optionallyWith(
        metricGroups.map(value =>
          value.map { item =>
            MetricGroup.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.metricGroups)
      .optionallyWith(
        peerVpcAwsAccountId.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.peerVpcAwsAccountId)
      .optionallyWith(
        peerVpcId.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.peerVpcId)
      .optionallyWith(fleetType.map(value => value.unwrap))(_.fleetType)
      .optionallyWith(
        instanceRoleArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.instanceRoleArn)
      .optionallyWith(
        certificateConfiguration.map(value => value.buildAwsValue())
      )(_.certificateConfiguration)
      .optionallyWith(
        locations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.locations)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.CreateFleetRequest.ReadOnly =
    zio.aws.gamelift.model.CreateFleetRequest.wrap(buildAwsValue())
}
object CreateFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.CreateFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.CreateFleetRequest =
      zio.aws.gamelift.model.CreateFleetRequest(
        name,
        description.map(value => value),
        buildId.map(value => value),
        scriptId.map(value => value),
        serverLaunchPath.map(value => value),
        serverLaunchParameters.map(value => value),
        logPaths.map(value => value),
        ec2InstanceType,
        ec2InboundPermissions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        newGameSessionProtectionPolicy.map(value => value),
        runtimeConfiguration.map(value => value.asEditable),
        resourceCreationLimitPolicy.map(value => value.asEditable),
        metricGroups.map(value => value),
        peerVpcAwsAccountId.map(value => value),
        peerVpcId.map(value => value),
        fleetType.map(value => value),
        instanceRoleArn.map(value => value),
        certificateConfiguration.map(value => value.asEditable),
        locations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: NonZeroAndMaxString
    def description: Option[NonZeroAndMaxString]
    def buildId: Option[BuildIdOrArn]
    def scriptId: Option[ScriptIdOrArn]
    def serverLaunchPath: Option[LaunchPathStringModel]
    def serverLaunchParameters: Option[LaunchParametersStringModel]
    def logPaths: Option[List[NonZeroAndMaxString]]
    def ec2InstanceType: zio.aws.gamelift.model.EC2InstanceType
    def ec2InboundPermissions
        : Option[List[zio.aws.gamelift.model.IpPermission.ReadOnly]]
    def newGameSessionProtectionPolicy
        : Option[zio.aws.gamelift.model.ProtectionPolicy]
    def runtimeConfiguration
        : Option[zio.aws.gamelift.model.RuntimeConfiguration.ReadOnly]
    def resourceCreationLimitPolicy
        : Option[zio.aws.gamelift.model.ResourceCreationLimitPolicy.ReadOnly]
    def metricGroups: Option[List[MetricGroup]]
    def peerVpcAwsAccountId: Option[NonZeroAndMaxString]
    def peerVpcId: Option[NonZeroAndMaxString]
    def fleetType: Option[zio.aws.gamelift.model.FleetType]
    def instanceRoleArn: Option[NonEmptyString]
    def certificateConfiguration
        : Option[zio.aws.gamelift.model.CertificateConfiguration.ReadOnly]
    def locations
        : Option[List[zio.aws.gamelift.model.LocationConfiguration.ReadOnly]]
    def tags: Option[List[zio.aws.gamelift.model.Tag.ReadOnly]]
    def getName: ZIO[Any, Nothing, NonZeroAndMaxString] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("description", description)
    def getBuildId: ZIO[Any, AwsError, BuildIdOrArn] =
      AwsError.unwrapOptionField("buildId", buildId)
    def getScriptId: ZIO[Any, AwsError, ScriptIdOrArn] =
      AwsError.unwrapOptionField("scriptId", scriptId)
    def getServerLaunchPath: ZIO[Any, AwsError, LaunchPathStringModel] =
      AwsError.unwrapOptionField("serverLaunchPath", serverLaunchPath)
    def getServerLaunchParameters
        : ZIO[Any, AwsError, LaunchParametersStringModel] = AwsError
      .unwrapOptionField("serverLaunchParameters", serverLaunchParameters)
    def getLogPaths: ZIO[Any, AwsError, List[NonZeroAndMaxString]] =
      AwsError.unwrapOptionField("logPaths", logPaths)
    def getEc2InstanceType
        : ZIO[Any, Nothing, zio.aws.gamelift.model.EC2InstanceType] =
      ZIO.succeed(ec2InstanceType)
    def getEc2InboundPermissions: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.IpPermission.ReadOnly
    ]] =
      AwsError.unwrapOptionField("ec2InboundPermissions", ec2InboundPermissions)
    def getNewGameSessionProtectionPolicy
        : ZIO[Any, AwsError, zio.aws.gamelift.model.ProtectionPolicy] =
      AwsError.unwrapOptionField(
        "newGameSessionProtectionPolicy",
        newGameSessionProtectionPolicy
      )
    def getRuntimeConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.RuntimeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("runtimeConfiguration", runtimeConfiguration)
    def getResourceCreationLimitPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.ResourceCreationLimitPolicy.ReadOnly
    ] = AwsError.unwrapOptionField(
      "resourceCreationLimitPolicy",
      resourceCreationLimitPolicy
    )
    def getMetricGroups: ZIO[Any, AwsError, List[MetricGroup]] =
      AwsError.unwrapOptionField("metricGroups", metricGroups)
    def getPeerVpcAwsAccountId: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("peerVpcAwsAccountId", peerVpcAwsAccountId)
    def getPeerVpcId: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("peerVpcId", peerVpcId)
    def getFleetType: ZIO[Any, AwsError, zio.aws.gamelift.model.FleetType] =
      AwsError.unwrapOptionField("fleetType", fleetType)
    def getInstanceRoleArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("instanceRoleArn", instanceRoleArn)
    def getCertificateConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.CertificateConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "certificateConfiguration",
      certificateConfiguration
    )
    def getLocations: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.LocationConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("locations", locations)
    def getTags: ZIO[Any, AwsError, List[zio.aws.gamelift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.CreateFleetRequest
  ) extends zio.aws.gamelift.model.CreateFleetRequest.ReadOnly {
    override val name: NonZeroAndMaxString =
      zio.aws.gamelift.model.primitives.NonZeroAndMaxString(impl.name())
    override val description: Option[NonZeroAndMaxString] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val buildId: Option[BuildIdOrArn] = scala
      .Option(impl.buildId())
      .map(value => zio.aws.gamelift.model.primitives.BuildIdOrArn(value))
    override val scriptId: Option[ScriptIdOrArn] = scala
      .Option(impl.scriptId())
      .map(value => zio.aws.gamelift.model.primitives.ScriptIdOrArn(value))
    override val serverLaunchPath: Option[LaunchPathStringModel] = scala
      .Option(impl.serverLaunchPath())
      .map(value =>
        zio.aws.gamelift.model.primitives.LaunchPathStringModel(value)
      )
    override val serverLaunchParameters: Option[LaunchParametersStringModel] =
      scala
        .Option(impl.serverLaunchParameters())
        .map(value =>
          zio.aws.gamelift.model.primitives.LaunchParametersStringModel(value)
        )
    override val logPaths: Option[List[NonZeroAndMaxString]] = scala
      .Option(impl.logPaths())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(item)
        }.toList
      )
    override val ec2InstanceType: zio.aws.gamelift.model.EC2InstanceType =
      zio.aws.gamelift.model.EC2InstanceType.wrap(impl.ec2InstanceType())
    override val ec2InboundPermissions
        : Option[List[zio.aws.gamelift.model.IpPermission.ReadOnly]] = scala
      .Option(impl.ec2InboundPermissions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.IpPermission.wrap(item)
        }.toList
      )
    override val newGameSessionProtectionPolicy
        : Option[zio.aws.gamelift.model.ProtectionPolicy] = scala
      .Option(impl.newGameSessionProtectionPolicy())
      .map(value => zio.aws.gamelift.model.ProtectionPolicy.wrap(value))
    override val runtimeConfiguration
        : Option[zio.aws.gamelift.model.RuntimeConfiguration.ReadOnly] = scala
      .Option(impl.runtimeConfiguration())
      .map(value => zio.aws.gamelift.model.RuntimeConfiguration.wrap(value))
    override val resourceCreationLimitPolicy
        : Option[zio.aws.gamelift.model.ResourceCreationLimitPolicy.ReadOnly] =
      scala
        .Option(impl.resourceCreationLimitPolicy())
        .map(value =>
          zio.aws.gamelift.model.ResourceCreationLimitPolicy.wrap(value)
        )
    override val metricGroups: Option[List[MetricGroup]] = scala
      .Option(impl.metricGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.primitives.MetricGroup(item)
        }.toList
      )
    override val peerVpcAwsAccountId: Option[NonZeroAndMaxString] = scala
      .Option(impl.peerVpcAwsAccountId())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val peerVpcId: Option[NonZeroAndMaxString] = scala
      .Option(impl.peerVpcId())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val fleetType: Option[zio.aws.gamelift.model.FleetType] = scala
      .Option(impl.fleetType())
      .map(value => zio.aws.gamelift.model.FleetType.wrap(value))
    override val instanceRoleArn: Option[NonEmptyString] = scala
      .Option(impl.instanceRoleArn())
      .map(value => zio.aws.gamelift.model.primitives.NonEmptyString(value))
    override val certificateConfiguration
        : Option[zio.aws.gamelift.model.CertificateConfiguration.ReadOnly] =
      scala
        .Option(impl.certificateConfiguration())
        .map(value =>
          zio.aws.gamelift.model.CertificateConfiguration.wrap(value)
        )
    override val locations
        : Option[List[zio.aws.gamelift.model.LocationConfiguration.ReadOnly]] =
      scala
        .Option(impl.locations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.LocationConfiguration.wrap(item)
          }.toList
        )
    override val tags: Option[List[zio.aws.gamelift.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.CreateFleetRequest
  ): zio.aws.gamelift.model.CreateFleetRequest.ReadOnly = new Wrapper(impl)
}
