package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateFleetResponse(
    fleetAttributes: Option[zio.aws.gamelift.model.FleetAttributes] = None,
    locationStates: Option[Iterable[zio.aws.gamelift.model.LocationState]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.CreateFleetResponse = {
    import CreateFleetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.CreateFleetResponse
      .builder()
      .optionallyWith(fleetAttributes.map(value => value.buildAwsValue()))(
        _.fleetAttributes
      )
      .optionallyWith(
        locationStates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.locationStates)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.CreateFleetResponse.ReadOnly =
    zio.aws.gamelift.model.CreateFleetResponse.wrap(buildAwsValue())
}
object CreateFleetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.CreateFleetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.CreateFleetResponse =
      zio.aws.gamelift.model.CreateFleetResponse(
        fleetAttributes.map(value => value.asEditable),
        locationStates.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def fleetAttributes: Option[zio.aws.gamelift.model.FleetAttributes.ReadOnly]
    def locationStates
        : Option[List[zio.aws.gamelift.model.LocationState.ReadOnly]]
    def getFleetAttributes
        : ZIO[Any, AwsError, zio.aws.gamelift.model.FleetAttributes.ReadOnly] =
      AwsError.unwrapOptionField("fleetAttributes", fleetAttributes)
    def getLocationStates: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.LocationState.ReadOnly
    ]] = AwsError.unwrapOptionField("locationStates", locationStates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.CreateFleetResponse
  ) extends zio.aws.gamelift.model.CreateFleetResponse.ReadOnly {
    override val fleetAttributes
        : Option[zio.aws.gamelift.model.FleetAttributes.ReadOnly] = scala
      .Option(impl.fleetAttributes())
      .map(value => zio.aws.gamelift.model.FleetAttributes.wrap(value))
    override val locationStates
        : Option[List[zio.aws.gamelift.model.LocationState.ReadOnly]] = scala
      .Option(impl.locationStates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.LocationState.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.CreateFleetResponse
  ): zio.aws.gamelift.model.CreateFleetResponse.ReadOnly = new Wrapper(impl)
}
