package zio.aws.gamelift.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{
  IamRoleArn,
  WholeNumber,
  PositiveInteger,
  GameServerGroupName,
  VpcSubnet
}
import scala.jdk.CollectionConverters._
final case class CreateGameServerGroupRequest(
    gameServerGroupName: GameServerGroupName,
    roleArn: IamRoleArn,
    minSize: WholeNumber,
    maxSize: PositiveInteger,
    launchTemplate: zio.aws.gamelift.model.LaunchTemplateSpecification,
    instanceDefinitions: Iterable[zio.aws.gamelift.model.InstanceDefinition],
    autoScalingPolicy: Option[
      zio.aws.gamelift.model.GameServerGroupAutoScalingPolicy
    ] = None,
    balancingStrategy: Option[zio.aws.gamelift.model.BalancingStrategy] = None,
    gameServerProtectionPolicy: Option[
      zio.aws.gamelift.model.GameServerProtectionPolicy
    ] = None,
    vpcSubnets: Option[Iterable[VpcSubnet]] = None,
    tags: Option[Iterable[zio.aws.gamelift.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.CreateGameServerGroupRequest = {
    import CreateGameServerGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.CreateGameServerGroupRequest
      .builder()
      .gameServerGroupName(
        GameServerGroupName.unwrap(gameServerGroupName): java.lang.String
      )
      .roleArn(IamRoleArn.unwrap(roleArn): java.lang.String)
      .minSize(WholeNumber.unwrap(minSize): Integer)
      .maxSize(PositiveInteger.unwrap(maxSize): Integer)
      .launchTemplate(launchTemplate.buildAwsValue())
      .instanceDefinitions(instanceDefinitions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(autoScalingPolicy.map(value => value.buildAwsValue()))(
        _.autoScalingPolicy
      )
      .optionallyWith(balancingStrategy.map(value => value.unwrap))(
        _.balancingStrategy
      )
      .optionallyWith(gameServerProtectionPolicy.map(value => value.unwrap))(
        _.gameServerProtectionPolicy
      )
      .optionallyWith(
        vpcSubnets.map(value =>
          value.map { item =>
            VpcSubnet.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSubnets)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.CreateGameServerGroupRequest.ReadOnly =
    zio.aws.gamelift.model.CreateGameServerGroupRequest.wrap(buildAwsValue())
}
object CreateGameServerGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.CreateGameServerGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.CreateGameServerGroupRequest =
      zio.aws.gamelift.model.CreateGameServerGroupRequest(
        gameServerGroupName,
        roleArn,
        minSize,
        maxSize,
        launchTemplate.asEditable,
        instanceDefinitions.map { item =>
          item.asEditable
        },
        autoScalingPolicy.map(value => value.asEditable),
        balancingStrategy.map(value => value),
        gameServerProtectionPolicy.map(value => value),
        vpcSubnets.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def gameServerGroupName: GameServerGroupName
    def roleArn: IamRoleArn
    def minSize: WholeNumber
    def maxSize: PositiveInteger
    def launchTemplate
        : zio.aws.gamelift.model.LaunchTemplateSpecification.ReadOnly
    def instanceDefinitions
        : List[zio.aws.gamelift.model.InstanceDefinition.ReadOnly]
    def autoScalingPolicy: Option[
      zio.aws.gamelift.model.GameServerGroupAutoScalingPolicy.ReadOnly
    ]
    def balancingStrategy: Option[zio.aws.gamelift.model.BalancingStrategy]
    def gameServerProtectionPolicy
        : Option[zio.aws.gamelift.model.GameServerProtectionPolicy]
    def vpcSubnets: Option[List[VpcSubnet]]
    def tags: Option[List[zio.aws.gamelift.model.Tag.ReadOnly]]
    def getGameServerGroupName: ZIO[Any, Nothing, GameServerGroupName] =
      ZIO.succeed(gameServerGroupName)
    def getRoleArn: ZIO[Any, Nothing, IamRoleArn] = ZIO.succeed(roleArn)
    def getMinSize: ZIO[Any, Nothing, WholeNumber] = ZIO.succeed(minSize)
    def getMaxSize: ZIO[Any, Nothing, PositiveInteger] = ZIO.succeed(maxSize)
    def getLaunchTemplate: ZIO[
      Any,
      Nothing,
      zio.aws.gamelift.model.LaunchTemplateSpecification.ReadOnly
    ] = ZIO.succeed(launchTemplate)
    def getInstanceDefinitions: ZIO[Any, Nothing, List[
      zio.aws.gamelift.model.InstanceDefinition.ReadOnly
    ]] = ZIO.succeed(instanceDefinitions)
    def getAutoScalingPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.GameServerGroupAutoScalingPolicy.ReadOnly
    ] = AwsError.unwrapOptionField("autoScalingPolicy", autoScalingPolicy)
    def getBalancingStrategy
        : ZIO[Any, AwsError, zio.aws.gamelift.model.BalancingStrategy] =
      AwsError.unwrapOptionField("balancingStrategy", balancingStrategy)
    def getGameServerProtectionPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.GameServerProtectionPolicy
    ] = AwsError.unwrapOptionField(
      "gameServerProtectionPolicy",
      gameServerProtectionPolicy
    )
    def getVpcSubnets: ZIO[Any, AwsError, List[VpcSubnet]] =
      AwsError.unwrapOptionField("vpcSubnets", vpcSubnets)
    def getTags: ZIO[Any, AwsError, List[zio.aws.gamelift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.CreateGameServerGroupRequest
  ) extends zio.aws.gamelift.model.CreateGameServerGroupRequest.ReadOnly {
    override val gameServerGroupName: GameServerGroupName =
      zio.aws.gamelift.model.primitives
        .GameServerGroupName(impl.gameServerGroupName())
    override val roleArn: IamRoleArn =
      zio.aws.gamelift.model.primitives.IamRoleArn(impl.roleArn())
    override val minSize: WholeNumber =
      zio.aws.gamelift.model.primitives.WholeNumber(impl.minSize())
    override val maxSize: PositiveInteger =
      zio.aws.gamelift.model.primitives.PositiveInteger(impl.maxSize())
    override val launchTemplate
        : zio.aws.gamelift.model.LaunchTemplateSpecification.ReadOnly =
      zio.aws.gamelift.model.LaunchTemplateSpecification
        .wrap(impl.launchTemplate())
    override val instanceDefinitions
        : List[zio.aws.gamelift.model.InstanceDefinition.ReadOnly] = impl
      .instanceDefinitions()
      .asScala
      .map { item =>
        zio.aws.gamelift.model.InstanceDefinition.wrap(item)
      }
      .toList
    override val autoScalingPolicy: Option[
      zio.aws.gamelift.model.GameServerGroupAutoScalingPolicy.ReadOnly
    ] = scala
      .Option(impl.autoScalingPolicy())
      .map(value =>
        zio.aws.gamelift.model.GameServerGroupAutoScalingPolicy.wrap(value)
      )
    override val balancingStrategy
        : Option[zio.aws.gamelift.model.BalancingStrategy] = scala
      .Option(impl.balancingStrategy())
      .map(value => zio.aws.gamelift.model.BalancingStrategy.wrap(value))
    override val gameServerProtectionPolicy
        : Option[zio.aws.gamelift.model.GameServerProtectionPolicy] = scala
      .Option(impl.gameServerProtectionPolicy())
      .map(value =>
        zio.aws.gamelift.model.GameServerProtectionPolicy.wrap(value)
      )
    override val vpcSubnets: Option[List[VpcSubnet]] = scala
      .Option(impl.vpcSubnets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.primitives.VpcSubnet(item)
        }.toList
      )
    override val tags: Option[List[zio.aws.gamelift.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.CreateGameServerGroupRequest
  ): zio.aws.gamelift.model.CreateGameServerGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
