package zio.aws.gamelift.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{
  FleetIdOrArn,
  WholeNumber,
  LocationStringModel,
  IdStringModel,
  LargeGameSessionData,
  NonZeroAndMaxString,
  AliasIdOrArn
}
import scala.jdk.CollectionConverters._
final case class CreateGameSessionRequest(
    fleetId: Option[FleetIdOrArn] = None,
    aliasId: Option[AliasIdOrArn] = None,
    maximumPlayerSessionCount: WholeNumber,
    name: Option[NonZeroAndMaxString] = None,
    gameProperties: Option[Iterable[zio.aws.gamelift.model.GameProperty]] =
      None,
    creatorId: Option[NonZeroAndMaxString] = None,
    gameSessionId: Option[IdStringModel] = None,
    idempotencyToken: Option[IdStringModel] = None,
    gameSessionData: Option[LargeGameSessionData] = None,
    location: Option[LocationStringModel] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.CreateGameSessionRequest = {
    import CreateGameSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.CreateGameSessionRequest
      .builder()
      .optionallyWith(
        fleetId.map(value => FleetIdOrArn.unwrap(value): java.lang.String)
      )(_.fleetId)
      .optionallyWith(
        aliasId.map(value => AliasIdOrArn.unwrap(value): java.lang.String)
      )(_.aliasId)
      .maximumPlayerSessionCount(
        WholeNumber.unwrap(maximumPlayerSessionCount): Integer
      )
      .optionallyWith(
        name.map(value => NonZeroAndMaxString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        gameProperties.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.gameProperties)
      .optionallyWith(
        creatorId.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.creatorId)
      .optionallyWith(
        gameSessionId.map(value =>
          IdStringModel.unwrap(value): java.lang.String
        )
      )(_.gameSessionId)
      .optionallyWith(
        idempotencyToken.map(value =>
          IdStringModel.unwrap(value): java.lang.String
        )
      )(_.idempotencyToken)
      .optionallyWith(
        gameSessionData.map(value =>
          LargeGameSessionData.unwrap(value): java.lang.String
        )
      )(_.gameSessionData)
      .optionallyWith(
        location.map(value =>
          LocationStringModel.unwrap(value): java.lang.String
        )
      )(_.location)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.CreateGameSessionRequest.ReadOnly =
    zio.aws.gamelift.model.CreateGameSessionRequest.wrap(buildAwsValue())
}
object CreateGameSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.CreateGameSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.CreateGameSessionRequest =
      zio.aws.gamelift.model.CreateGameSessionRequest(
        fleetId.map(value => value),
        aliasId.map(value => value),
        maximumPlayerSessionCount,
        name.map(value => value),
        gameProperties.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        creatorId.map(value => value),
        gameSessionId.map(value => value),
        idempotencyToken.map(value => value),
        gameSessionData.map(value => value),
        location.map(value => value)
      )
    def fleetId: Option[FleetIdOrArn]
    def aliasId: Option[AliasIdOrArn]
    def maximumPlayerSessionCount: WholeNumber
    def name: Option[NonZeroAndMaxString]
    def gameProperties
        : Option[List[zio.aws.gamelift.model.GameProperty.ReadOnly]]
    def creatorId: Option[NonZeroAndMaxString]
    def gameSessionId: Option[IdStringModel]
    def idempotencyToken: Option[IdStringModel]
    def gameSessionData: Option[LargeGameSessionData]
    def location: Option[LocationStringModel]
    def getFleetId: ZIO[Any, AwsError, FleetIdOrArn] =
      AwsError.unwrapOptionField("fleetId", fleetId)
    def getAliasId: ZIO[Any, AwsError, AliasIdOrArn] =
      AwsError.unwrapOptionField("aliasId", aliasId)
    def getMaximumPlayerSessionCount: ZIO[Any, Nothing, WholeNumber] =
      ZIO.succeed(maximumPlayerSessionCount)
    def getName: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("name", name)
    def getGameProperties: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.GameProperty.ReadOnly
    ]] = AwsError.unwrapOptionField("gameProperties", gameProperties)
    def getCreatorId: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("creatorId", creatorId)
    def getGameSessionId: ZIO[Any, AwsError, IdStringModel] =
      AwsError.unwrapOptionField("gameSessionId", gameSessionId)
    def getIdempotencyToken: ZIO[Any, AwsError, IdStringModel] =
      AwsError.unwrapOptionField("idempotencyToken", idempotencyToken)
    def getGameSessionData: ZIO[Any, AwsError, LargeGameSessionData] =
      AwsError.unwrapOptionField("gameSessionData", gameSessionData)
    def getLocation: ZIO[Any, AwsError, LocationStringModel] =
      AwsError.unwrapOptionField("location", location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.CreateGameSessionRequest
  ) extends zio.aws.gamelift.model.CreateGameSessionRequest.ReadOnly {
    override val fleetId: Option[FleetIdOrArn] = scala
      .Option(impl.fleetId())
      .map(value => zio.aws.gamelift.model.primitives.FleetIdOrArn(value))
    override val aliasId: Option[AliasIdOrArn] = scala
      .Option(impl.aliasId())
      .map(value => zio.aws.gamelift.model.primitives.AliasIdOrArn(value))
    override val maximumPlayerSessionCount: WholeNumber =
      zio.aws.gamelift.model.primitives
        .WholeNumber(impl.maximumPlayerSessionCount())
    override val name: Option[NonZeroAndMaxString] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val gameProperties
        : Option[List[zio.aws.gamelift.model.GameProperty.ReadOnly]] = scala
      .Option(impl.gameProperties())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.GameProperty.wrap(item)
        }.toList
      )
    override val creatorId: Option[NonZeroAndMaxString] = scala
      .Option(impl.creatorId())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val gameSessionId: Option[IdStringModel] = scala
      .Option(impl.gameSessionId())
      .map(value => zio.aws.gamelift.model.primitives.IdStringModel(value))
    override val idempotencyToken: Option[IdStringModel] = scala
      .Option(impl.idempotencyToken())
      .map(value => zio.aws.gamelift.model.primitives.IdStringModel(value))
    override val gameSessionData: Option[LargeGameSessionData] = scala
      .Option(impl.gameSessionData())
      .map(value =>
        zio.aws.gamelift.model.primitives.LargeGameSessionData(value)
      )
    override val location: Option[LocationStringModel] = scala
      .Option(impl.location())
      .map(value =>
        zio.aws.gamelift.model.primitives.LocationStringModel(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.CreateGameSessionRequest
  ): zio.aws.gamelift.model.CreateGameSessionRequest.ReadOnly = new Wrapper(
    impl
  )
}
