package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateGameSessionResponse(
    gameSession: Option[zio.aws.gamelift.model.GameSession] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.CreateGameSessionResponse = {
    import CreateGameSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.CreateGameSessionResponse
      .builder()
      .optionallyWith(gameSession.map(value => value.buildAwsValue()))(
        _.gameSession
      )
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.CreateGameSessionResponse.ReadOnly =
    zio.aws.gamelift.model.CreateGameSessionResponse.wrap(buildAwsValue())
}
object CreateGameSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.CreateGameSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.CreateGameSessionResponse =
      zio.aws.gamelift.model
        .CreateGameSessionResponse(gameSession.map(value => value.asEditable))
    def gameSession: Option[zio.aws.gamelift.model.GameSession.ReadOnly]
    def getGameSession
        : ZIO[Any, AwsError, zio.aws.gamelift.model.GameSession.ReadOnly] =
      AwsError.unwrapOptionField("gameSession", gameSession)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.CreateGameSessionResponse
  ) extends zio.aws.gamelift.model.CreateGameSessionResponse.ReadOnly {
    override val gameSession
        : Option[zio.aws.gamelift.model.GameSession.ReadOnly] = scala
      .Option(impl.gameSession())
      .map(value => zio.aws.gamelift.model.GameSession.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.CreateGameSessionResponse
  ): zio.aws.gamelift.model.CreateGameSessionResponse.ReadOnly = new Wrapper(
    impl
  )
}
