package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateMatchmakingConfigurationResponse(
    configuration: Option[zio.aws.gamelift.model.MatchmakingConfiguration] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.CreateMatchmakingConfigurationResponse = {
    import CreateMatchmakingConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.CreateMatchmakingConfigurationResponse
      .builder()
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.CreateMatchmakingConfigurationResponse.ReadOnly =
    zio.aws.gamelift.model.CreateMatchmakingConfigurationResponse
      .wrap(buildAwsValue())
}
object CreateMatchmakingConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.CreateMatchmakingConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.gamelift.model.CreateMatchmakingConfigurationResponse =
      zio.aws.gamelift.model.CreateMatchmakingConfigurationResponse(
        configuration.map(value => value.asEditable)
      )
    def configuration
        : Option[zio.aws.gamelift.model.MatchmakingConfiguration.ReadOnly]
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.MatchmakingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.CreateMatchmakingConfigurationResponse
  ) extends zio.aws.gamelift.model.CreateMatchmakingConfigurationResponse.ReadOnly {
    override val configuration
        : Option[zio.aws.gamelift.model.MatchmakingConfiguration.ReadOnly] =
      scala
        .Option(impl.configuration())
        .map(value =>
          zio.aws.gamelift.model.MatchmakingConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.CreateMatchmakingConfigurationResponse
  ): zio.aws.gamelift.model.CreateMatchmakingConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
